/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.Order;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.ui.CancelReplacePanel;
import quickfix.examples.banzai.ui.ExecutionPanel;
import quickfix.examples.banzai.ui.OrderEntryPanel;
import quickfix.examples.banzai.ui.OrderPanel;

public class BanzaiPanel
extends JPanel
implements Observer,
ActionListener {
    private OrderEntryPanel orderEntryPanel = null;
    private OrderPanel orderPanel = null;
    private ExecutionPanel executionPanel = null;
    private CancelReplacePanel cancelReplacePanel = null;
    private OrderTableModel orderTableModel = null;

    public BanzaiPanel(OrderTableModel orderTableModel, ExecutionTableModel executionTableModel, BanzaiApplication application) {
        this.setName("BanzaiPanel");
        this.orderTableModel = orderTableModel;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        this.orderEntryPanel = new OrderEntryPanel(orderTableModel, application);
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.orderEntryPanel, constraints);
        ++constraints.gridx;
        constraints.weighty = 10.0;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.orderPanel = new OrderPanel(orderTableModel, application);
        this.executionPanel = new ExecutionPanel(executionTableModel);
        tabbedPane.add("Orders", this.orderPanel);
        tabbedPane.add("Executions", this.executionPanel);
        this.add((Component)tabbedPane, constraints);
        this.cancelReplacePanel = new CancelReplacePanel(application);
        constraints.weighty = 0.0;
        this.add((Component)this.cancelReplacePanel, constraints);
        this.cancelReplacePanel.setEnabled(false);
        this.orderEntryPanel.addActionListener(this);
        this.orderPanel.orderTable().getSelectionModel().addListSelectionListener(new OrderSelection());
        this.cancelReplacePanel.addActionListener(this);
        application.addOrderObserver(this);
    }

    public void update(Observable o, Object arg) {
        this.cancelReplacePanel.update();
    }

    public void actionPerformed(ActionEvent e) {
        ListSelectionModel selection = this.orderPanel.orderTable().getSelectionModel();
        selection.clearSelection();
    }

    private class OrderSelection
    implements ListSelectionListener {
        private OrderSelection() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel selection = BanzaiPanel.this.orderPanel.orderTable().getSelectionModel();
            if (selection.isSelectionEmpty()) {
                BanzaiPanel.this.orderEntryPanel.clearMessage();
                return;
            }
            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            int selectedRow = 0;
            int numSelected = 0;
            for (int i = firstIndex; i <= lastIndex; ++i) {
                if (!selection.isSelectedIndex(i)) continue;
                selectedRow = i;
                ++numSelected;
            }
            if (numSelected > 1) {
                BanzaiPanel.this.orderEntryPanel.clearMessage();
            } else {
                Order order = BanzaiPanel.this.orderTableModel.getOrder(selectedRow);
                if (order != null) {
                    BanzaiPanel.this.orderEntryPanel.setMessage(order.getMessage());
                    BanzaiPanel.this.cancelReplacePanel.setOrder(order);
                }
            }
        }
    }
}

