/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import quickfix.examples.banzai.Order;

public class OrderTableModel
extends AbstractTableModel {
    private static final int SYMBOL = 0;
    private static final int QUANTITY = 1;
    private static final int OPEN = 2;
    private static final int EXECUTED = 3;
    private static final int SIDE = 4;
    private static final int TYPE = 5;
    private static final int LIMITPRICE = 6;
    private static final int STOPPRICE = 7;
    private static final int AVGPX = 8;
    private static final int TARGET = 9;
    private HashMap rowToOrder = new HashMap();
    private HashMap idToRow = new HashMap();
    private HashMap idToOrder = new HashMap();
    private String[] headers = new String[]{"Symbol", "Quantity", "Open", "Executed", "Side", "Type", "Limit", "Stop", "AvgPx", "Target"};
    static /* synthetic */ Class class$java$lang$String;

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addOrder(Order order) {
        int row = this.rowToOrder.size();
        this.rowToOrder.put(new Integer(row), order);
        this.idToRow.put(order.getID(), new Integer(row));
        this.idToOrder.put(order.getID(), order);
        this.fireTableRowsInserted(row, row);
    }

    public void updateOrder(Order order, String id) {
        if (!id.equals(order.getID())) {
            String originalID = order.getID();
            order.setID(id);
            this.replaceOrder(order, originalID);
            return;
        }
        Integer row = (Integer)this.idToRow.get(order.getID());
        if (row == null) {
            return;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void replaceOrder(Order order, String originalID) {
        Integer row = (Integer)this.idToRow.get(originalID);
        if (row == null) {
            return;
        }
        this.rowToOrder.put(row, order);
        this.idToRow.put(order.getID(), row);
        this.idToOrder.put(order.getID(), order);
        this.fireTableRowsUpdated(row, row);
    }

    public void addID(Order order, String newID) {
        this.idToOrder.put(newID, order);
    }

    public Order getOrder(String id) {
        Order order = (Order)this.idToOrder.get(id);
        return order;
    }

    public Order getOrder(int row) {
        return (Order)this.rowToOrder.get(new Integer(row));
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = OrderTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getRowCount() {
        return this.rowToOrder.size();
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public String getColumnName(int columnIndex) {
        return this.headers[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Order order = (Order)this.rowToOrder.get(new Integer(rowIndex));
        switch (columnIndex) {
            case 0: {
                return order.getSymbol();
            }
            case 1: {
                return new Integer(order.getQuantity());
            }
            case 2: {
                return new Integer(order.getOpen());
            }
            case 3: {
                return new Integer(order.getExecuted());
            }
            case 4: {
                return order.getSide();
            }
            case 5: {
                return order.getType();
            }
            case 6: {
                return order.getLimit();
            }
            case 7: {
                return order.getStop();
            }
            case 8: {
                return new Double(order.getAvgPx());
            }
            case 9: {
                return order.getSessionID().getTargetCompID();
            }
        }
        return new String();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

