/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.DefaultMessageFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.ui.BanzaiFrame;

public class Banzai {
    private static Logger log = LoggerFactory.getLogger((Class)(class$quickfix$examples$banzai$Banzai == null ? (class$quickfix$examples$banzai$Banzai = Banzai.class$("quickfix.examples.banzai.Banzai")) : class$quickfix$examples$banzai$Banzai));
    private static Banzai banzai;
    private Initiator initiator = null;
    private JFrame frame = null;
    static /* synthetic */ Class class$quickfix$examples$banzai$Banzai;

    public Banzai(String[] args) throws Exception {
        InputStream inputStream = null;
        if (args.length == 0) {
            inputStream = (class$quickfix$examples$banzai$Banzai == null ? (class$quickfix$examples$banzai$Banzai = Banzai.class$("quickfix.examples.banzai.Banzai")) : class$quickfix$examples$banzai$Banzai).getResourceAsStream("banzai.cfg");
        } else if (args.length == 1) {
            inputStream = new FileInputStream(args[0]);
        }
        if (inputStream == null) {
            System.out.println("usage: " + (class$quickfix$examples$banzai$Banzai == null ? (class$quickfix$examples$banzai$Banzai = Banzai.class$("quickfix.examples.banzai.Banzai")) : class$quickfix$examples$banzai$Banzai).getName() + " [configFile].");
            return;
        }
        SessionSettings settings = new SessionSettings(inputStream);
        OrderTableModel orderTableModel = new OrderTableModel();
        ExecutionTableModel executionTableModel = new ExecutionTableModel();
        BanzaiApplication application = new BanzaiApplication(orderTableModel, executionTableModel);
        FileStoreFactory messageStoreFactory = new FileStoreFactory(settings);
        ScreenLogFactory logFactory = new ScreenLogFactory(true, true, true);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        this.initiator = new SocketInitiator(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.frame = new BanzaiFrame(orderTableModel, executionTableModel, application);
        this.frame.setDefaultCloseOperation(3);
    }

    public void logon() {
        try {
            this.initiator.start();
        }
        catch (Exception e) {
            log.error("error starting initiator", (Throwable)e);
        }
    }

    public void logout() {
        this.initiator.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Banzai banzai = Banzai.banzai;
        synchronized (banzai) {
            Banzai.banzai.notify();
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public static Banzai get() {
        return banzai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        banzai = new Banzai(args);
        if (!System.getProperties().containsKey("openfix")) {
            banzai.logon();
        }
        Banzai banzai = Banzai.banzai;
        synchronized (banzai) {
            Banzai.banzai.wait();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

