/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private volatile Boolean isStarted = Boolean.FALSE;
    private SingleThreadedEventHandlingStrategy eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this);

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
    }

    public void block() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.block();
    }

    public boolean poll() throws ConfigError, RuntimeError {
        this.initialize();
        return this.eventHandlingStrategy.poll();
    }

    public void start() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.blockInThread();
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean forceDisconnect) {
        this.eventHandlingStrategy.stopHandlingMessages();
        this.logoutAllSessions(forceDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ConfigError {
        Boolean bl = this.isStarted;
        synchronized (bl) {
            if (this.isStarted == Boolean.FALSE) {
                this.initiateSessions(this.eventHandlingStrategy);
            }
            this.isStarted = Boolean.TRUE;
        }
    }
}

