/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import quickfix.Log;
import quickfix.Message;
import quickfix.MessageStore;
import quickfix.RuntimeError;
import quickfix.SystemTime;

public class SessionState {
    private Log log;
    private boolean logonReceived;
    private boolean logoutSent;
    private boolean logonSent;
    private boolean initiator;
    private long logonTimeoutMs = 10000L;
    private long logoutTimeoutMs = 2000L;
    private int testRequestCounter;
    private MessageStore messageStore;
    private long lastSentTime;
    private long lastReceivedTime;
    private boolean withinHeartBeat;
    private long heartbeatMillis = Long.MAX_VALUE;
    private int heartBeatInterval;
    private HashMap messageQueue = new HashMap();
    private int[] resendRange = new int[]{0, 0};
    private boolean resetSent;
    private boolean resetReceived;
    private String logoutReason;

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(int heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
        this.heartbeatMillis = (long)heartBeatInterval * 1000L;
    }

    public boolean isHeartBeatNeeded() {
        long millisSinceLastSentTime = SystemTime.currentTimeMillis() - this.getLastSentTime();
        return millisSinceLastSentTime >= this.heartbeatMillis && this.getTestRequestCounter() == 0;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    public void setInitiator(boolean initiator) {
        this.initiator = initiator;
    }

    public long getLastReceivedTime() {
        return this.lastReceivedTime;
    }

    public void setLastReceivedTime(long lastReceivedTime) {
        this.lastReceivedTime = lastReceivedTime;
    }

    public long getLastSentTime() {
        return this.lastSentTime;
    }

    public void setLastSentTime(long lastSentTime) {
        this.lastSentTime = lastSentTime;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public boolean isLogonAlreadySent() {
        return this.isInitiator() && this.isLogonSent();
    }

    public boolean isLogonReceived() {
        return this.logonReceived;
    }

    public void setLogonReceived(boolean logonReceived) {
        this.logonReceived = logonReceived;
    }

    public boolean isLogonSendNeeded() {
        return this.isInitiator() && !this.isLogonSent();
    }

    public boolean isLogonSent() {
        return this.logonSent;
    }

    public void setLogonSent(boolean logonSent) {
        this.logonSent = logonSent;
    }

    public boolean isLogonTimedOut() {
        return SystemTime.currentTimeMillis() - this.getLastReceivedTime() >= this.logonTimeoutMs;
    }

    public void setLogonTimeout(int logonTimeout) {
        this.logonTimeoutMs = (long)logonTimeout * 1000L;
    }

    public void setLogoutTimeout(int logoutTimeout) {
        this.logoutTimeoutMs = (long)logoutTimeout * 1000L;
    }

    public boolean isLogoutSent() {
        return this.logoutSent;
    }

    public void setLogoutSent(boolean logoutSent) {
        this.logoutSent = logoutSent;
    }

    public boolean isLogoutTimedOut() {
        return this.isLogoutSent() && SystemTime.currentTimeMillis() - this.getLastSentTime() >= this.logoutTimeoutMs;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public int getTestRequestCounter() {
        return this.testRequestCounter;
    }

    public void clearTestRequestCounter() {
        this.testRequestCounter = 0;
    }

    public void incrementTestRequestCounter() {
        ++this.testRequestCounter;
    }

    public boolean isTestRequestNeeded() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= 1.5 * (double)(this.getTestRequestCounter() + 1) * (double)this.heartbeatMillis;
    }

    private long timeSinceLastReceivedMessage() {
        return SystemTime.currentTimeMillis() - this.getLastReceivedTime();
    }

    public boolean isTimedOut() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= 2.4 * (double)this.heartbeatMillis;
    }

    public boolean isWithinHeartBeat() {
        return this.withinHeartBeat;
    }

    public boolean set(int sequence, String message) throws IOException {
        return this.messageStore.set(sequence, message);
    }

    public void get(int first, int last, Collection messages) throws IOException {
        this.messageStore.get(first, last, messages);
    }

    public void enqueue(int sequence, Message message) {
        this.messageQueue.put(new Integer(sequence), message);
    }

    public Message dequeue(int sequence) {
        return (Message)this.messageQueue.get(new Integer(sequence));
    }

    public void clearQueue() {
        this.messageQueue.clear();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.messageStore.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.messageStore.getNextTargetMsgSeqNum();
    }

    public void setNextTargetMsgSeqNum(int sequence) throws IOException {
        this.messageStore.setNextTargetMsgSeqNum(sequence);
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.messageStore.incrNextSenderMsgSeqNum();
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.messageStore.incrNextTargetMsgSeqNum();
    }

    public Date getCreationTime() throws IOException {
        return this.messageStore.getCreationTime();
    }

    public void reset() {
        try {
            this.messageStore.reset();
        }
        catch (IOException e) {
            throw new RuntimeError(e);
        }
    }

    public void setResendRange(int low, int high) {
        this.resendRange[0] = low;
        this.resendRange[1] = high;
    }

    public boolean isResendRequested() {
        return this.resendRange[0] != 0 || this.resendRange[1] != 0;
    }

    public int[] getResendRange() {
        return this.resendRange;
    }

    public boolean isResetReceived() {
        return this.resetReceived;
    }

    public void setResetReceived(boolean resetReceived) {
        this.resetReceived = resetReceived;
    }

    public boolean isResetSent() {
        return this.resetSent;
    }

    public void setResetSent(boolean resetSent) {
        this.resetSent = resetSent;
    }

    public void setLogoutReason(String reason) {
        this.logoutReason = reason;
    }

    public String getLogoutReason() {
        return this.logoutReason;
    }

    public void clearLogoutReason() {
        this.logoutReason = "";
    }
}

