/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quickfix.ConfigError;
import quickfix.DayConverter;
import quickfix.FieldConvertError;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

class SessionSchedule {
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})");
    private Calendar calendar1 = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private Calendar calendar2 = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private int endDay = -1;
    private Calendar endTime;
    private TimeZone sessionTimeZone;
    private int startDay = -1;
    private Calendar startTime;

    SessionSchedule(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        Matcher matcher;
        boolean startDayPresent = settings.isSetting(sessionID, "StartDay");
        boolean endDayPresent = settings.isSetting(sessionID, "EndDay");
        if (startDayPresent && !endDayPresent) {
            throw new ConfigError("Session " + sessionID + ": StartDay used without EndDay");
        }
        if (endDayPresent && !startDayPresent) {
            throw new ConfigError("Session " + sessionID + ": EndDay used without StartDay");
        }
        boolean weeklySession = startDayPresent && endDayPresent;
        String startTimeString = settings.getString(sessionID, "StartTime");
        String endTimeString = settings.getString(sessionID, "EndTime");
        if (settings.isSetting(sessionID, "TimeZone")) {
            String sessionTimeZoneID = settings.getString(sessionID, "TimeZone");
            this.sessionTimeZone = TimeZone.getTimeZone(sessionTimeZoneID);
            if ("GMT".equals(this.sessionTimeZone.getID()) && !"GMT".equals(sessionTimeZoneID)) {
                throw new ConfigError("Unrecognized time zone '" + sessionTimeZoneID + "' for session " + sessionID);
            }
        } else {
            this.sessionTimeZone = TimeZone.getTimeZone("UTC");
        }
        if (!(matcher = TIME_PATTERN.matcher(startTimeString)).find()) {
            throw new ConfigError("Session " + sessionID + ": could not parse start time '" + startTimeString + "'.");
        }
        Calendar localTime = SystemTime.getUtcCalendar();
        localTime.setTimeZone(this.sessionTimeZone);
        localTime.set(11, Integer.parseInt(matcher.group(1)));
        localTime.set(12, Integer.parseInt(matcher.group(2)));
        localTime.set(13, Integer.parseInt(matcher.group(3)));
        this.startTime = SystemTime.getUtcCalendar();
        this.startTime.setTime(localTime.getTime());
        if (weeklySession) {
            this.startDay = this.getDay(settings, sessionID, "StartDay", -1);
        }
        if (!(matcher = TIME_PATTERN.matcher(endTimeString)).find()) {
            throw new ConfigError("Session " + sessionID + ": could not parse end time '" + endTimeString + "'.");
        }
        localTime.set(11, Integer.parseInt(matcher.group(1)));
        localTime.set(12, Integer.parseInt(matcher.group(2)));
        localTime.set(13, Integer.parseInt(matcher.group(3)));
        this.endTime = SystemTime.getUtcCalendar();
        this.endTime.setTime(localTime.getTime());
        if (weeklySession) {
            this.endDay = this.getDay(settings, sessionID, "EndDay", -1);
        }
        this.calendar1.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    SessionSchedule(Date startTime, Date endTime, int startDay, int endDay) {
        this.startTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.startTime.setTime(startTime);
        this.endTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.endTime.setTime(endTime);
        this.startDay = startDay;
        this.endDay = endDay;
        if (startDay > 0 && endDay > 0 && startDay == endDay && endTime.after(startTime)) {
            endTime = startTime;
        }
        this.calendar1.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.calendar2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private Calendar getDateOnly(Calendar timestampIn, Calendar dateOnlyOut) {
        dateOnlyOut.set(11, 0);
        dateOnlyOut.set(12, 0);
        dateOnlyOut.set(13, 0);
        dateOnlyOut.set(timestampIn.get(1), timestampIn.get(2), timestampIn.get(5));
        return dateOnlyOut;
    }

    private Calendar getTimeOnly(Calendar timestampIn, Calendar timeOnlyOut) {
        Calendar cal = SystemTime.getUtcCalendar();
        timeOnlyOut.set(1, cal.get(1));
        timeOnlyOut.set(2, cal.get(2));
        timeOnlyOut.set(5, cal.get(5));
        timeOnlyOut.set(11, timestampIn.get(11));
        timeOnlyOut.set(12, timestampIn.get(12));
        timeOnlyOut.set(13, timestampIn.get(13));
        return timeOnlyOut;
    }

    private void adjustSessionTimes() {
        Calendar cal = SystemTime.getUtcCalendar();
        this.startTime.set(1, cal.get(1));
        this.startTime.set(2, cal.get(2));
        this.startTime.set(5, cal.get(5));
        this.endTime.set(1, cal.get(1));
        this.endTime.set(2, cal.get(2));
        this.endTime.set(5, cal.get(5));
    }

    private boolean isDailySessionTime(Calendar timestamp) {
        Calendar timeOnly = this.getTimeOnly(timestamp, this.calendar1);
        return this.startTime.before(this.endTime) ? (timeOnly.after(this.startTime) || timeOnly.equals(this.startTime)) && (timeOnly.before(this.endTime) || timeOnly.equals(this.endTime)) : timeOnly.after(this.startTime) || timeOnly.equals(this.startTime) || timeOnly.before(this.endTime) || timeOnly.equals(this.endTime);
    }

    private boolean isSameDailySession(Calendar timestamp1, Calendar timestamp2) {
        if (!this.isDailySessionTime(timestamp1) || !this.isDailySessionTime(timestamp2)) {
            return false;
        }
        if (timestamp1.equals(timestamp2)) {
            return true;
        }
        Calendar date1 = this.getDateOnly(timestamp1, this.calendar1);
        Calendar date2 = this.getDateOnly(timestamp2, this.calendar2);
        if (this.startTime.before(this.endTime) || this.startTime.equals(this.endTime)) {
            return date1.equals(date2);
        }
        long sessionLength = 86400000L - (this.startTime.getTimeInMillis() - this.endTime.getTimeInMillis());
        long timeInMillis1 = timestamp1.getTimeInMillis();
        long timeInMillis2 = timestamp2.getTimeInMillis();
        if (timestamp1.after(timestamp2)) {
            long delta = this.getTimeOnly(timestamp2, this.calendar1).getTimeInMillis() - this.startTime.getTimeInMillis();
            if (delta < 0L) {
                delta = 86400000L + delta;
            }
            return timeInMillis1 - timeInMillis2 < sessionLength - delta;
        }
        return timeInMillis2 - timeInMillis1 < sessionLength;
    }

    public boolean isSameSession(Calendar time1, Calendar time2) {
        this.adjustSessionTimes();
        if (this.startDay < 0 && this.endDay < 0) {
            return this.isSameDailySession(time1, time2);
        }
        return this.isSameWeeklySession(time1, time2);
    }

    private boolean isSameWeeklySession(Calendar timestamp1, Calendar timestamp2) {
        Calendar timeOnly;
        if (!this.isWeeklySessionTime(timestamp1) || !this.isWeeklySessionTime(timestamp2)) {
            return false;
        }
        if (timestamp1.equals(timestamp2)) {
            return true;
        }
        int time1Range = timestamp1.get(7) - this.startDay;
        int time2Range = timestamp2.get(7) - this.startDay;
        if (time1Range == 0 && (timeOnly = this.getTimeOnly(timestamp1, this.calendar1)).before(this.startTime)) {
            time1Range = 7;
        }
        if (time2Range == 0 && (timeOnly = this.getTimeOnly(timestamp2, this.calendar2)).before(this.startTime)) {
            time2Range = 7;
        }
        timestamp1 = (Calendar)timestamp1.clone();
        timestamp1.add(5, -1 * time1Range);
        timestamp2 = (Calendar)timestamp2.clone();
        timestamp2.add(5, -1 * time2Range);
        return timestamp1.get(1) == timestamp2.get(1) && timestamp1.get(6) == timestamp2.get(6);
    }

    public boolean isSessionTime() {
        this.adjustSessionTimes();
        Calendar now = SystemTime.getUtcCalendar();
        if (this.startDay < 0 && this.endDay < 0) {
            return this.isDailySessionTime(now);
        }
        return this.isWeeklySessionTime(now);
    }

    private boolean isWeekly() {
        return this.startDay > 0 && this.endDay > 0;
    }

    private boolean isWeeklySessionTime(Calendar timestamp) {
        int currentDay = timestamp.get(7);
        Calendar currentTime = this.getTimeOnly(timestamp, this.calendar1);
        if (this.startDay == this.endDay) {
            if (currentTime.before(this.startTime) && currentTime.after(this.endTime)) {
                return false;
            }
        } else if (this.startDay < this.endDay) {
            if (currentDay < this.startDay || currentDay > this.endDay) {
                return false;
            }
            if (currentDay == this.startDay && currentTime.before(this.startTime)) {
                return false;
            }
            if (currentDay == this.endDay && currentTime.after(this.endTime)) {
                return false;
            }
        } else if (this.startDay > this.endDay) {
            if (currentDay < this.startDay && currentDay > this.endDay) {
                return false;
            }
            if (currentDay == this.startDay && currentTime.before(this.startTime)) {
                return false;
            }
            if (currentDay == this.endDay && currentTime.after(this.endTime)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        this.adjustSessionTimes();
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat dowFormat = new SimpleDateFormat("EEEE");
        dowFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
        timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar now = SystemTime.getUtcCalendar();
        now.setTime(this.startTime.getTime());
        if (this.isWeekly()) {
            buf.append("weekly, ");
            now.set(7, this.startDay);
            buf.append(dowFormat.format(now.getTime()));
            buf.append(" ");
        } else {
            buf.append("daily, ");
        }
        buf.append(timeFormat.format(now.getTime()));
        buf.append(" - ");
        now.setTime(this.endTime.getTime());
        if (this.isWeekly()) {
            now.set(7, this.endDay);
            buf.append(dowFormat.format(now.getTime()));
            buf.append(" ");
        }
        buf.append(timeFormat.format(now.getTime()));
        if (this.sessionTimeZone != null && !TimeZone.getTimeZone("UTC").equals(this.sessionTimeZone)) {
            dowFormat.setTimeZone(this.sessionTimeZone);
            timeFormat.setTimeZone(this.sessionTimeZone);
            buf.append(" (");
            now.setTime(this.startTime.getTime());
            if (this.isWeekly()) {
                now.set(7, this.startDay);
                buf.append(dowFormat.format(now.getTime()));
                buf.append(" ");
            }
            buf.append(timeFormat.format(now.getTime()));
            buf.append(" - ");
            now.setTime(this.endTime.getTime());
            if (this.isWeekly()) {
                now.set(7, this.endDay);
                buf.append(dowFormat.format(now.getTime()));
                buf.append(" ");
            }
            buf.append(timeFormat.format(now.getTime()));
            buf.append(")");
        }
        return buf.toString();
    }

    private int getDay(SessionSettings settings, SessionID sessionID, String key, int defaultValue) throws ConfigError, FieldConvertError {
        return DayConverter.toInteger(settings.getString(sessionID, key));
    }
}

