/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import quickfix.Application;
import quickfix.BusinessRejectReasonText;
import quickfix.DataDictionary;
import quickfix.DoNotSend;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.InvalidMessage;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.MessageUtils;
import quickfix.RefreshableMessageStore;
import quickfix.RejectLogon;
import quickfix.Responder;
import quickfix.SessionException;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionRejectReasonText;
import quickfix.SessionSchedule;
import quickfix.SessionState;
import quickfix.SystemTime;
import quickfix.UnsupportedMessageType;
import quickfix.UnsupportedVersion;

public class Session {
    public static final String SETTING_HEARTBTINT = "HeartBtInt";
    public static final String SETTING_CHECK_LATENCY = "CheckLatency";
    public static final String SETTING_MAX_LATENCY = "MaxLatency";
    public static final String SETTING_START_DAY = "StartDay";
    public static final String SETTING_END_DAY = "EndDay";
    public static final String SETTING_TIMEZONE = "TimeZone";
    public static final String SETTING_START_TIME = "StartTime";
    public static final String SETTING_END_TIME = "EndTime";
    public static final String SETTING_USE_DATA_DICTIONARY = "UseDataDictionary";
    public static final String SETTING_DATA_DICTIONARY = "DataDictionary";
    public static final String SETTING_VALIDATE_FIELDS_OUT_OF_ORDER = "ValidateFieldsOutOfOrder";
    public static final String SETTING_VALIDATE_FIELDS_HAVE_VALUES = "ValidateFieldsHaveValues";
    public static final String SETTING_LOGON_TIMEOUT = "LogonTimeout";
    public static final String SETTING_LOGOUT_TIMEOUT = "LogoutTimeout";
    public static final String SETTING_RESET_ON_LOGOUT = "ResetOnLogout";
    public static final String SETTING_RESET_ON_DISCONNECT = "ResetOnDisconnect";
    public static final String SETTING_MILLISECONDS_IN_TIMESTAMP = "MillisecondsInTimeStamp";
    public static final String SETTING_VALIDATE_USER_DEFINED_FIELDS = "ValidateUserDefinedFields";
    public static final String SETTING_RESET_WHEN_INITIATING_LOGON = "SendResetSeqNumFlag";
    public static final String SETTING_DESCRIPTION = "Description";
    public static final String SETTING_REFRESH_STORE_AT_LOGON = "RefreshMessageStoreAtLogon";
    private Application application;
    private Responder responder;
    private SessionID sessionID;
    private DataDictionary dataDictionary;
    private SessionSchedule sessionSchedule;
    private MessageFactory messageFactory;
    private SessionState state = new SessionState();
    private static HashMap sessions = new HashMap();
    private boolean enabled;
    private boolean checkLatency;
    private int maxLatency;
    private boolean resetOnLogout;
    private boolean resetOnDisconnect;
    private boolean millisecondsInTimeStamp;
    private boolean resetWhenInitiatingLogon;
    private long lastSessionTimeCheck = 0L;
    private boolean lastSessionTimeResult = false;
    private boolean refreshMessageStoreAtLogon;

    Session(Application application, MessageStoreFactory messageStoreFactory, SessionID sessionID, DataDictionary dataDictionary, SessionSchedule sessionSchedule, LogFactory logFactory, MessageFactory messageFactory, int heartbeatInterval) {
        Log log = logFactory.create(sessionID);
        try {
            this.application = application;
            this.sessionID = sessionID;
            this.sessionSchedule = sessionSchedule;
            this.enabled = true;
            this.checkLatency = true;
            this.maxLatency = 120;
            this.resetOnLogout = false;
            this.resetOnDisconnect = false;
            this.resetWhenInitiatingLogon = false;
            this.millisecondsInTimeStamp = true;
            this.dataDictionary = dataDictionary;
            this.state.setHeartBeatInterval(heartbeatInterval);
            this.state.setInitiator(heartbeatInterval != 0);
            this.state.setMessageStore(messageStoreFactory.create(sessionID));
            this.messageFactory = messageFactory;
            if (logFactory != null) {
                this.state.setLog(log);
            }
            log.onEvent("Session " + this.sessionID + " schedule is " + sessionSchedule);
            if (!this.checkSessionTime()) {
                log.onEvent("Session state is not current; resetting " + this.sessionID);
                this.reset();
            }
            sessions.put(sessionID, this);
            application.onCreate(sessionID);
            log.onEvent("Created session: " + sessionID);
        }
        catch (IOException e) {
            LogUtil.logThrowable(log, "error during session construction", (Throwable)e);
        }
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    public synchronized Responder getResponder() {
        return this.responder;
    }

    private boolean checkSessionTime() throws IOException {
        return this.checkSessionTime(SystemTime.getDate());
    }

    private boolean checkSessionTime(Date date) throws IOException {
        if (this.sessionSchedule == null) {
            return true;
        }
        if (date.getTime() - this.lastSessionTimeCheck >= 1000L) {
            this.lastSessionTimeResult = this.sessionSchedule.isSameSession(SystemTime.getUtcCalendar(date), SystemTime.getUtcCalendar(this.state.getCreationTime()));
            this.lastSessionTimeCheck = date.getTime();
            return this.lastSessionTimeResult;
        }
        return this.lastSessionTimeResult;
    }

    public static boolean sendToTarget(Message message) throws SessionNotFound {
        return Session.sendToTarget(message, "");
    }

    public static boolean sendToTarget(Message message, String qualifier) throws SessionNotFound {
        try {
            String senderCompID = message.getHeader().getString(49);
            String targetCompID = message.getHeader().getString(56);
            return Session.sendToTarget(message, senderCompID, targetCompID, qualifier);
        }
        catch (SessionNotFound e) {
            throw e;
        }
        catch (FieldNotFound e) {
            throw new SessionNotFound("missing sender or target company ID");
        }
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID) throws SessionNotFound {
        return Session.sendToTarget(message, senderCompID, targetCompID, "");
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID, String qualifier) throws SessionNotFound {
        try {
            return Session.sendToTarget(message, new SessionID(message.getHeader().getString(8), senderCompID, targetCompID, qualifier));
        }
        catch (SessionNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public static boolean sendToTarget(Message message, SessionID sessionID) throws SessionNotFound {
        message.setSessionID(sessionID);
        Session session = Session.lookupSession(sessionID);
        if (session == null) {
            throw new SessionNotFound();
        }
        return session.send(message);
    }

    public static Session lookupSession(SessionID sessionID) {
        return (Session)sessions.get(sessionID);
    }

    public void logon() {
        this.state.clearLogoutReason();
        this.enabled = true;
    }

    private void initializeHeader(Message.Header header) {
        this.state.setLastSentTime(SystemTime.currentTimeMillis());
        header.setString(8, this.sessionID.getBeginString());
        header.setString(49, this.sessionID.getSenderCompID());
        header.setString(56, this.sessionID.getTargetCompID());
        header.setInt(34, this.getExpectedSenderNum());
        this.insertSendingTime(header);
    }

    private void insertSendingTime(Message.Header header) {
        boolean includeMillis = this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0 && this.millisecondsInTimeStamp;
        header.setUtcTimeStamp(52, SystemTime.getDate(), includeMillis);
    }

    public void logout() {
        this.enabled = false;
    }

    public void logout(String reason) {
        this.state.setLogoutReason(reason);
        this.logout();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean sentLogon() {
        return this.state.isLogonSent();
    }

    public boolean receivedLogon() {
        return this.state.isLogonReceived();
    }

    public boolean sentLogout() {
        return this.state.isLogoutSent();
    }

    public boolean isLoggedOn() {
        return this.sentLogon() && this.receivedLogon();
    }

    private boolean isResetOnLogonRequested() {
        return this.sessionID.getBeginString().compareTo("FIX.4.1") >= 0 && (this.resetWhenInitiatingLogon || this.resetOnLogout || this.resetOnDisconnect) && this.getExpectedSenderNum() == 1 && this.getExpectedTargetNum() == 1;
    }

    public void reset() throws IOException {
        this.generateLogout();
        this.disconnect();
        this.state.reset();
    }

    public void setNextSenderMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextSenderMsgSeqNum(num);
    }

    public void setNextTargetMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextTargetMsgSeqNum(num);
    }

    public int getExpectedSenderNum() {
        try {
            return this.state.getMessageStore().getNextSenderMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onEvent("getNextSenderMsgSeqNum failed: " + e.getMessage());
            return -1;
        }
    }

    public int getExpectedTargetNum() {
        try {
            return this.state.getMessageStore().getNextTargetMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onEvent("getNextTargetMsgSeqNum failed: " + e.getMessage());
            return -1;
        }
    }

    public Log getLog() {
        return this.state.getLog();
    }

    public MessageStore getStore() {
        return this.state.getMessageStore();
    }

    public synchronized void next(Message message) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.checkSessionTime()) {
            this.reset();
            return;
        }
        String msgType = message.getHeader().getString(35);
        try {
            String beginString;
            if (this.isStateRefreshNeeded(msgType)) {
                if (this.getStore() instanceof RefreshableMessageStore) {
                    this.getLog().onEvent("Refreshing message/state store at logon");
                    ((RefreshableMessageStore)this.getStore()).refresh();
                } else {
                    this.getLog().onEvent("Refresh at logon requested, but message store not capable: " + this.getStore().getClass().getName());
                }
            }
            if (!(beginString = message.getHeader().getString(8)).equals(this.sessionID.getBeginString())) {
                throw new UnsupportedVersion();
            }
            if (this.dataDictionary != null) {
                this.dataDictionary.validate(message);
            }
            if (msgType.equals("A")) {
                this.nextLogon(message);
            } else if (msgType.equals("0")) {
                this.nextHeartBeat(message);
            } else if (msgType.equals("1")) {
                this.nextTestRequest(message);
            } else if (msgType.equals("4")) {
                this.nextSequenceReset(message);
            } else if (msgType.equals("5")) {
                this.nextLogout(message);
            } else if (msgType.equals("2")) {
                this.nextResendRequest(message);
            } else if (msgType.equals("3")) {
                this.nextReject(message);
            } else {
                if (!this.verify(message)) {
                    return;
                }
                this.state.incrNextTargetMsgSeqNum();
            }
        }
        catch (FieldException e) {
            this.generateReject(message, e.getSessionRejectReason(), e.getField());
        }
        catch (FieldNotFound e) {
            if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0 && message.isApp()) {
                this.generateBusinessReject(message, 5);
            } else {
                this.generateReject(message, 1, e.field);
                if (msgType.equals("A")) {
                    this.getLog().onEvent("Required field missing from logon");
                    this.disconnect();
                }
            }
        }
        catch (IncorrectTagValue e) {
            this.generateReject(message, 5, e.field);
        }
        catch (InvalidMessage e) {
            this.getLog().onEvent("Skipping invalid message: " + e.getMessage());
        }
        catch (RejectLogon e) {
            String rejectMessage = e.getMessage() != null ? ": " + e.getMessage() : "";
            this.getLog().onEvent("Logon rejected" + rejectMessage);
            this.generateLogout(e.getMessage());
            this.disconnect();
        }
        catch (UnsupportedMessageType e) {
            if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
                this.generateBusinessReject(message, 3);
            } else {
                this.generateReject(message, "Unsupported message type");
            }
        }
        catch (UnsupportedVersion e) {
            if (msgType.equals("5")) {
                this.nextLogout(message);
            } else {
                this.generateLogout("Incorrect BeginString");
                this.state.incrNextTargetMsgSeqNum();
                this.disconnect();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "error processing message", (Throwable)e);
        }
        this.nextQueued();
        if (this.isLoggedOn()) {
            this.next();
        }
    }

    private boolean isStateRefreshNeeded(String msgType) {
        return this.refreshMessageStoreAtLogon && !this.getState().isInitiator() && msgType.equals("A");
    }

    private void nextReject(Message reject) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(reject)) {
            return;
        }
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private synchronized void nextResendRequest(Message resendRequest) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, InvalidMessage {
        if (!this.verify(resendRequest, false, false)) {
            return;
        }
        int beginSeqNo = resendRequest.getInt(7);
        int endSeqNo = resendRequest.getInt(16);
        this.getLog().onEvent("Received ResendRequest FROM: " + beginSeqNo + " TO: " + endSeqNo);
        String beginString = this.sessionID.getBeginString();
        if (beginString.compareTo("FIX.4.2") >= 0 && endSeqNo == 0 || beginString.compareTo("FIX.4.2") <= 0 && endSeqNo == 999999 || endSeqNo >= this.getExpectedSenderNum()) {
            endSeqNo = this.getExpectedSenderNum() - 1;
        }
        ArrayList messages = new ArrayList();
        this.state.get(beginSeqNo, endSeqNo, messages);
        int msgSeqNum = 0;
        int begin = 0;
        int current = beginSeqNo;
        for (int i = 0; i < messages.size(); ++i) {
            Message msg = new Message((String)messages.get(i), this.dataDictionary);
            msgSeqNum = msg.getHeader().getInt(34);
            String msgType = msg.getHeader().getString(35);
            if (current != msgSeqNum && begin == 0) {
                begin = current;
            }
            if (msgType.length() == 1 && "0A12345".indexOf(msgType) != -1) {
                if (begin == 0) {
                    begin = msgSeqNum;
                }
            } else if (this.resend(msg)) {
                if (begin != 0) {
                    this.generateSequenceReset(begin, msgSeqNum);
                }
                this.send(msg.toString());
                this.getLog().onEvent("Resending Message: " + msgSeqNum);
                begin = 0;
            } else if (begin == 0) {
                begin = msgSeqNum;
            }
            current = msgSeqNum + 1;
        }
        if (begin != 0) {
            this.generateSequenceReset(begin, msgSeqNum + 1);
        }
        if (endSeqNo > msgSeqNum) {
            int next = this.state.getNextSenderMsgSeqNum();
            if (++endSeqNo > next) {
                endSeqNo = next;
            }
            this.generateSequenceReset(beginSeqNo, endSeqNo);
        }
        if (!this.isTargetTooHigh(msgSeqNum = resendRequest.getHeader().getInt(34)) && !this.isTargetTooLow(msgSeqNum)) {
            this.state.incrNextTargetMsgSeqNum();
        }
    }

    private boolean isTargetTooLow(int msgSeqNum) throws IOException {
        return msgSeqNum < this.state.getNextTargetMsgSeqNum();
    }

    private void generateSequenceReset(int beginSeqNo, int endSeqNo) throws FieldNotFound {
        Message sequenceReset = this.messageFactory.create(this.sessionID.getBeginString(), "4");
        int newSeqNo = endSeqNo;
        sequenceReset.getHeader().setBoolean(43, true);
        sequenceReset.setInt(36, newSeqNo);
        this.initializeHeader(sequenceReset.getHeader());
        sequenceReset.getHeader().setUtcTimeStamp(122, sequenceReset.getHeader().getUtcTimeStamp(52));
        sequenceReset.getHeader().setInt(34, beginSeqNo);
        sequenceReset.setBoolean(123, true);
        this.sendRaw(sequenceReset, beginSeqNo);
        this.getLog().onEvent("Sent SequenceReset TO: " + newSeqNo);
    }

    private boolean resend(Message message) throws FieldNotFound {
        Message.Header header = message.getHeader();
        Date sendingTime = header.getUtcTimeStamp(52);
        header.setUtcTimeStamp(122, sendingTime);
        header.setBoolean(43, true);
        this.insertSendingTime(header);
        try {
            this.application.toApp(message, this.sessionID);
            return true;
        }
        catch (DoNotSend e) {
            return false;
        }
    }

    private void nextLogout(Message logout) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (!this.verify(logout, false, false)) {
            return;
        }
        if (!this.state.isLogoutSent()) {
            this.getLog().onEvent("Received logout request");
            this.generateLogout();
            this.getLog().onEvent("Sent logout response");
        } else {
            this.getLog().onEvent("Received logout response");
        }
        this.state.incrNextTargetMsgSeqNum();
        if (this.resetOnLogout) {
            this.state.reset();
        }
        this.disconnect();
    }

    private void generateLogout() {
        this.generateLogout(null);
    }

    private void generateLogout(String text) {
        Message logout = this.messageFactory.create(this.sessionID.getBeginString(), "5");
        this.initializeHeader(logout.getHeader());
        if (text != null && !"".equals(text)) {
            logout.setString(58, text);
        }
        this.sendRaw(logout, 0);
        this.state.setLogoutSent(true);
    }

    private void nextSequenceReset(Message sequenceReset) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        boolean isGapFill = false;
        if (sequenceReset.isSetField(123)) {
            isGapFill = sequenceReset.getBoolean(123);
        }
        if (!this.verify(sequenceReset, isGapFill, isGapFill)) {
            return;
        }
        if (sequenceReset.isSetField(36)) {
            int newSequence = sequenceReset.getInt(36);
            this.getLog().onEvent("Received SequenceReset FROM: " + this.getExpectedTargetNum() + " TO: " + newSequence);
            if (newSequence > this.getExpectedTargetNum()) {
                this.state.setNextTargetMsgSeqNum(newSequence);
            } else if (newSequence < this.getExpectedTargetNum()) {
                this.generateReject(sequenceReset, 5, 0);
            }
        }
    }

    public void generateReject(Message message, String str) throws FieldNotFound, IOException {
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        reject.reverseRoute(message.getHeader());
        this.initializeHeader(reject.getHeader());
        String msgType = message.getHeader().getString(35);
        String msgSeqNum = message.getHeader().getString(34);
        if (beginString.compareTo("FIX.4.2") >= 0) {
            reject.setString(372, msgType);
        }
        reject.setString(45, msgSeqNum);
        boolean isPossibleDuplicate = false;
        if (message.getHeader().isSetField(43)) {
            isPossibleDuplicate = message.getHeader().getBoolean(43);
        }
        if (!(msgType.equals("A") || msgType.equals("4") || isPossibleDuplicate)) {
            this.state.incrNextTargetMsgSeqNum();
        }
        reject.setString(58, str);
        this.sendRaw(reject, 0);
        this.getLog().onEvent("Message " + msgSeqNum + " Rejected: " + str);
    }

    private void generateReject(Message message, int err, int field) throws IOException, FieldNotFound {
        String reason = SessionRejectReasonText.getMessage(err);
        if (!this.state.isLogonReceived()) {
            String errorMessage = "Tried to send a reject while not logged on: " + reason + " (field " + field + ")";
            throw new SessionException(errorMessage);
        }
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        reject.reverseRoute(message.getHeader());
        this.initializeHeader(reject.getHeader());
        String msgType = "";
        if (message.getHeader().isSetField(35)) {
            msgType = message.getHeader().getString(35);
        }
        int msgSeqNum = 0;
        if (message.getHeader().isSetField(34)) {
            msgSeqNum = message.getHeader().getInt(34);
            reject.setInt(45, msgSeqNum);
        }
        boolean possDupFlag = false;
        if (message.getHeader().isSetField(43)) {
            possDupFlag = message.getHeader().getBoolean(43);
        }
        if (beginString.compareTo("FIX.4.2") >= 0) {
            if (!msgType.equals("")) {
                reject.setString(372, msgType);
            }
            if (beginString.equals("FIX.4.2") && err <= 11 || beginString.compareTo("FIX.4.2") > 0) {
                reject.setInt(373, err);
            }
        }
        if (!(msgType.equals("A") || msgType.equals("4") || msgSeqNum != this.getExpectedTargetNum() && possDupFlag)) {
            this.state.incrNextTargetMsgSeqNum();
        }
        if (reason != null && (field > 0 || err == 0)) {
            this.populateRejectReason(reject, field, reason);
            this.getLog().onEvent("Message " + msgSeqNum + " Rejected: " + reason + ":" + field);
        } else if (reason != null) {
            this.populateRejectReason(reject, reason);
            this.getLog().onEvent("Message " + msgSeqNum + " Rejected: " + reason);
        } else {
            this.getLog().onEvent("Message " + msgSeqNum + " Rejected");
        }
        this.sendRaw(reject, 0);
    }

    private void populateRejectReason(Message reject, String reason) {
        reject.setString(58, reason);
    }

    private void populateRejectReason(Message reject, int field, String reason) {
        if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
            reject.setInt(371, field);
            reject.setString(58, reason);
        } else {
            reject.setString(58, reason + " (" + field + ")");
        }
    }

    private void generateBusinessReject(Message message, int err) throws FieldNotFound, IOException {
        Message reject = this.messageFactory.create(this.sessionID.getBeginString(), "j");
        this.initializeHeader(reject.getHeader());
        String msgType = message.getHeader().getString(35);
        String msgSeqNum = message.getHeader().getString(34);
        reject.setString(372, msgType);
        reject.setString(45, msgSeqNum);
        reject.setInt(380, err);
        this.state.incrNextTargetMsgSeqNum();
        String reason = BusinessRejectReasonText.getMessage(err);
        this.populateRejectReason(reject, reason);
        this.sendRaw(reject, 0);
        this.getLog().onEvent("Message " + msgSeqNum + " Rejected: " + reason);
    }

    private void nextTestRequest(Message testRequest) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(testRequest)) {
            return;
        }
        this.generateHeartbeat(testRequest);
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private void generateHeartbeat(Message testRequest) throws FieldNotFound {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        if (testRequest.isSetField(112)) {
            heartbeat.setString(112, testRequest.getString(112));
        }
        this.sendRaw(heartbeat, 0);
    }

    private void nextHeartBeat(Message heartBeat) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(heartBeat)) {
            return;
        }
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private boolean verify(Message msg, boolean checkTooHigh, boolean checkTooLow) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        String msgType;
        try {
            int[] range;
            Message.Header header = msg.getHeader();
            String senderCompID = header.getString(49);
            String targetCompID = header.getString(56);
            Date sendingTime = header.getUtcTimeStamp(52);
            msgType = header.getString(35);
            int msgSeqNum = 0;
            if (checkTooHigh || checkTooLow) {
                msgSeqNum = header.getInt(34);
            }
            if (!this.validLogonState(msgType)) {
                throw new SessionException("Logon state is not valid for message (MsgType=" + msgType + ")");
            }
            if (!this.isGoodTime(sendingTime)) {
                this.doBadTime(msg);
                return false;
            }
            if (!this.isCorrectCompID(senderCompID, targetCompID)) {
                this.doBadCompID(msg);
                return false;
            }
            this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
            this.state.clearTestRequestCounter();
            if (checkTooHigh && this.isTargetTooHigh(msgSeqNum)) {
                this.doTargetTooHigh(msg);
                return false;
            }
            if (checkTooLow && this.isTargetTooLow(msgSeqNum)) {
                this.doTargetTooLow(msg);
                return false;
            }
            if ((checkTooHigh || checkTooLow) && this.state.isResendRequested() && msgSeqNum >= (range = this.state.getResendRange())[1]) {
                this.getLog().onEvent("ResendRequest for messages FROM: " + range[0] + " TO: " + range[1] + " has been satisfied.");
                this.state.setResendRange(0, 0);
            }
        }
        catch (FieldNotFound e) {
            throw e;
        }
        catch (Exception e) {
            this.getLog().onEvent(e.getClass().getName() + " " + e.getMessage());
            this.disconnect();
            return false;
        }
        this.fromCallback(msgType, msg, this.sessionID);
        return true;
    }

    private boolean doTargetTooLow(Message msg) throws FieldNotFound, IOException {
        Message.Header header = msg.getHeader();
        boolean possDupFlag = false;
        if (header.isSetField(43)) {
            possDupFlag = header.getBoolean(43);
        }
        if (!possDupFlag) {
            int msgSeqNum = header.getInt(34);
            String text = "MsgSeqNum too low, expecting " + this.getExpectedTargetNum() + " but received " + msgSeqNum;
            this.generateLogout(text);
            throw new SessionException(text);
        }
        return this.doPossDup(msg);
    }

    private void doBadCompID(Message msg) throws IOException, FieldNotFound {
        this.generateReject(msg, 9, 0);
        this.generateLogout();
    }

    private void doBadTime(Message msg) throws IOException, FieldNotFound {
        this.generateReject(msg, 10, 0);
        this.generateLogout();
    }

    private boolean isGoodTime(Date sendingTime) {
        if (!this.checkLatency) {
            return true;
        }
        return Math.abs(SystemTime.currentTimeMillis() - sendingTime.getTime()) / 1000L <= (long)this.maxLatency;
    }

    private void fromCallback(String msgType, Message msg, SessionID sessionID2) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (msgType.length() == 1 && "0A12345".indexOf(msgType) != -1) {
            this.application.fromAdmin(msg, this.sessionID);
        } else {
            this.application.fromApp(msg, this.sessionID);
        }
    }

    public boolean validLogonState(String msgType) {
        if (msgType.equals("A") && this.state.isResetSent() || this.state.isResetReceived()) {
            return true;
        }
        if (msgType.equals("A") && !this.state.isLogonReceived() || !msgType.equals("A") && this.state.isLogonReceived()) {
            return true;
        }
        if (msgType.equals("5") && this.state.isLogonSent()) {
            return true;
        }
        if (!msgType.equals("5") && this.state.isLogoutSent()) {
            return true;
        }
        if (msgType.equals("4")) {
            return true;
        }
        return msgType.equals("3");
    }

    private boolean verify(Message message) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        return this.verify(message, true, true);
    }

    public synchronized void next() throws IOException {
        if (!this.enabled) {
            if (this.isLoggedOn()) {
                if (!this.state.isLogoutSent()) {
                    this.getLog().onEvent("Initiated logout request");
                    this.generateLogout(this.state.getLogoutReason());
                }
            } else {
                return;
            }
        }
        if (!this.checkSessionTime()) {
            this.reset();
            return;
        }
        if (!this.state.isLogonReceived()) {
            if (this.state.isLogonSendNeeded()) {
                if (this.generateLogon()) {
                    this.getLog().onEvent("Initiated logon request");
                } else {
                    this.getLog().onEvent("Error during logon request initiation");
                }
            } else if (this.state.isLogonAlreadySent() && this.state.isLogonTimedOut()) {
                this.getLog().onEvent("Timed out waiting for logon response");
                this.disconnect();
            }
            return;
        }
        if (this.state.getHeartBeatInterval() == 0) {
            return;
        }
        if (this.state.isLogoutTimedOut()) {
            this.getLog().onEvent("Timed out waiting for logout response");
            this.disconnect();
        }
        if (this.state.isWithinHeartBeat()) {
            return;
        }
        if (this.state.isTimedOut()) {
            this.getLog().onEvent("Timed out waiting for heartbeat");
            this.disconnect();
        } else if (this.state.isTestRequestNeeded()) {
            this.generateTestRequest("TEST");
            this.state.incrementTestRequestCounter();
            this.getLog().onEvent("Sent test request TEST");
        } else if (this.state.isHeartBeatNeeded()) {
            this.generateHeartbeat();
        }
    }

    private void generateHeartbeat() {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        this.sendRaw(heartbeat, 0);
    }

    private void generateTestRequest(String id) {
        Message testRequest = this.messageFactory.create(this.sessionID.getBeginString(), "1");
        this.initializeHeader(testRequest.getHeader());
        testRequest.setString(112, id);
        this.sendRaw(testRequest, 0);
    }

    private boolean generateLogon() {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        logon.setInt(108, this.state.getHeartBeatInterval());
        if (this.isResetOnLogonRequested()) {
            logon.setBoolean(141, true);
        }
        this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
        this.state.clearTestRequestCounter();
        this.state.setLogonSent(true);
        return this.sendRaw(logon, 0);
    }

    public synchronized void disconnect() throws IOException {
        if (this.responder != null) {
            this.getLog().onEvent("Disconnecting");
            this.responder.disconnect();
            this.setResponder(null);
        }
        if (this.state.isLogonReceived() || this.state.isLogonSent()) {
            this.state.setLogonReceived(false);
            this.state.setLogonSent(false);
            this.application.onLogout(this.sessionID);
        }
        this.state.setLogoutSent(false);
        this.state.setResetReceived(false);
        this.state.setResetSent(false);
        this.state.clearQueue();
        this.state.clearLogoutReason();
        if (this.resetOnDisconnect) {
            this.state.reset();
        }
        this.state.setResendRange(0, 0);
    }

    private void nextLogon(Message logon) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        String senderCompID = logon.getHeader().getString(49);
        String targetCompID = logon.getHeader().getString(56);
        if (logon.isSetField(141)) {
            this.state.setResetReceived(logon.getBoolean(141));
        }
        if (this.state.isResetReceived()) {
            this.getLog().onEvent("Logon contains ResetSeqNumFlag=Y, resetting sequence numbers to 1");
            if (!this.state.isResetSent()) {
                this.state.reset();
            }
        }
        if (this.state.isLogonSendNeeded() && !this.state.isResetReceived()) {
            this.getLog().onEvent("Received logon response before sending request");
            this.disconnect();
            return;
        }
        if (!this.verify(logon, false, true)) {
            return;
        }
        this.state.setLogonReceived(true);
        if (this.isCorrectCompID(senderCompID, targetCompID)) {
            this.state.setLogonReceived(true);
        }
        if (!this.state.isInitiator() || this.state.isResetSent() && !this.state.isResetReceived()) {
            this.getLog().onEvent("Received logon request");
            this.generateLogon(logon);
            this.getLog().onEvent("Responding to logon request");
        } else {
            this.getLog().onEvent("Received logon response");
        }
        this.state.setResetSent(false);
        this.state.setResetReceived(false);
        int sequence = logon.getHeader().getInt(34);
        if (this.isTargetTooHigh(sequence) && !this.resetWhenInitiatingLogon) {
            this.doTargetTooHigh(logon);
        } else {
            this.state.incrNextTargetMsgSeqNum();
            this.nextQueued();
        }
        if (this.isLoggedOn()) {
            this.application.onLogon(this.sessionID);
        }
    }

    private void nextQueued() throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        while (this.nextQueued(this.getExpectedTargetNum())) {
        }
    }

    private boolean nextQueued(int num) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        Message msg = this.state.dequeue(num);
        if (msg != null) {
            this.getLog().onEvent("Processing QUEUED message: " + num);
            String msgType = msg.getHeader().getString(35);
            if (msgType.equals("A") || msgType.equals("2")) {
                this.state.incrNextTargetMsgSeqNum();
            } else {
                this.next(msg.toString());
            }
            return true;
        }
        return false;
    }

    private void next(String msg) throws InvalidMessage, FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        try {
            String msgType = MessageUtils.getMessageType(msg);
            Message message = this.messageFactory.create(this.sessionID.getBeginString(), msgType);
            message.fromString(msg, this.dataDictionary, false);
            this.next(message);
        }
        catch (InvalidMessage e) {
            String message = e.getMessage();
            this.getLog().onEvent(message);
            if ("A".equals(MessageUtils.getMessageType(msg))) {
                this.getLog().onEvent("Logon message is not valid");
                this.disconnect();
            }
            throw e;
        }
    }

    private void doTargetTooHigh(Message msg) throws FieldNotFound {
        int[] range;
        Message.Header header = msg.getHeader();
        String beginString = header.getString(8);
        int msgSeqNum = header.getInt(34);
        this.getLog().onEvent("MsgSeqNum too high, expecting " + this.getExpectedTargetNum() + " but received " + msgSeqNum);
        this.state.enqueue(msgSeqNum, msg);
        if (this.state.isResendRequested() && msgSeqNum >= (range = this.state.getResendRange())[0]) {
            this.getLog().onEvent("Already sent ResendRequest FROM: " + range[0] + " TO: " + range[1] + ".  Not sending another.");
            return;
        }
        this.generateResendRequest(beginString, msgSeqNum);
    }

    private void generateResendRequest(String beginString, int msgSeqNum) {
        Message resendRequest = this.messageFactory.create(beginString, "2");
        int beginSeqNo = this.getExpectedTargetNum();
        int endSeqNo = msgSeqNum - 1;
        if (beginString.compareTo("FIX.4.2") >= 0) {
            endSeqNo = 0;
        } else if (beginString.compareTo("FIX.4.1") <= 0) {
            endSeqNo = 999999;
        }
        resendRequest.setInt(7, beginSeqNo);
        resendRequest.setInt(16, endSeqNo);
        this.initializeHeader(resendRequest.getHeader());
        this.sendRaw(resendRequest, 0);
        this.getLog().onEvent("Sent ResendRequest FROM: " + beginSeqNo + " TO: " + endSeqNo);
        this.state.setResendRange(beginSeqNo, msgSeqNum - 1);
    }

    private boolean doPossDup(Message msg) throws FieldNotFound, IOException {
        Message.Header header = msg.getHeader();
        String msgType = header.getString(35);
        Date sendingTime = header.getUtcTimeStamp(52);
        if (!msgType.equals("4")) {
            if (!header.isSetField(122)) {
                this.generateReject(msg, 1, 122);
                return false;
            }
            Date origSendingTime = header.getUtcTimeStamp(122);
            if (origSendingTime.compareTo(sendingTime) > 0) {
                this.generateReject(msg, 10, 0);
                this.generateLogout();
                return false;
            }
        }
        return true;
    }

    private boolean isTargetTooHigh(int sequence) throws IOException {
        return sequence > this.state.getNextTargetMsgSeqNum();
    }

    private void generateLogon(Message otherLogon) throws FieldNotFound {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        if (this.state.isResetReceived()) {
            logon.setBoolean(141, true);
        }
        logon.setInt(108, otherLogon.getInt(108));
        this.initializeHeader(logon.getHeader());
        this.sendRaw(logon, 0);
        this.state.setLogonSent(true);
    }

    private synchronized boolean sendRaw(Message message, int num) {
        try {
            boolean result = false;
            Message.Header header = message.getHeader();
            String msgType = header.getString(35);
            this.initializeHeader(header);
            if (num > 0) {
                header.setInt(34, num);
            }
            String messageString = null;
            if (message.isAdmin()) {
                this.application.toAdmin(message, this.sessionID);
                if (msgType.equals("A") && !this.state.isResetReceived()) {
                    boolean resetSeqNumFlag = false;
                    if (message.isSetField(141)) {
                        resetSeqNumFlag = message.getBoolean(141);
                    }
                    if (resetSeqNumFlag) {
                        this.state.reset();
                        message.getHeader().setInt(34, this.getExpectedSenderNum());
                    }
                    this.state.setResetSent(resetSeqNumFlag);
                }
                messageString = message.toString();
                if (msgType.equals("A") || msgType.equals("5") || msgType.equals("2") || msgType.equals("4") || this.isLoggedOn()) {
                    result = this.send(messageString);
                }
            } else {
                try {
                    this.application.toApp(message, this.sessionID);
                    messageString = message.toString();
                    if (this.isLoggedOn()) {
                        result = this.send(messageString);
                    }
                }
                catch (DoNotSend e) {
                    return false;
                }
            }
            if (num == 0) {
                int msgSeqNum = header.getInt(34);
                this.state.set(msgSeqNum, messageString);
                this.state.incrNextSenderMsgSeqNum();
            }
            return result;
        }
        catch (IOException e) {
            this.getLog().onEvent("Error Reading/Writing in MessageStore");
            return false;
        }
        catch (FieldNotFound e) {
            LogUtil.logThrowable(this.state.getLog(), "Error accessing message fields", (Throwable)e);
            return false;
        }
    }

    public boolean send(Message message) {
        message.getHeader().removeField(43);
        message.getHeader().removeField(122);
        return this.sendRaw(message, 0);
    }

    private boolean send(String messageString) {
        if (this.responder == null) {
            this.getLog().onEvent("No responder, not sending message");
            return false;
        }
        this.getLog().onOutgoing(messageString);
        return this.responder.send(messageString);
    }

    private boolean isCorrectCompID(String senderCompID, String targetCompID) {
        return this.sessionID.getSenderCompID().equals(targetCompID) && this.sessionID.getTargetCompID().equals(senderCompID);
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public void setResetOnLogout(boolean flag) {
        this.resetOnLogout = flag;
    }

    public void setResetOnDisconnect(boolean flag) {
        this.resetOnDisconnect = flag;
    }

    public SessionState getState() {
        return this.state;
    }

    public void setCheckLatency(boolean flag) {
        this.checkLatency = flag;
    }

    public void setMaxLatency(int latency) {
        this.maxLatency = latency;
    }

    public void setMillisecondsInTimestamp(boolean flag) {
        this.millisecondsInTimeStamp = flag;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public boolean isSessionTime() {
        return this.sessionSchedule.isSessionTime();
    }

    void setResetWhenInitiatingLogon(boolean flag) {
        this.resetWhenInitiatingLogon = flag;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setRefreshMessageStoreAtLogon(boolean refreshMessageStoreAtLogon) {
        this.refreshMessageStoreAtLogon = refreshMessageStoreAtLogon;
    }

    public static boolean doesSessionExist(SessionID sessionID) {
        return sessions.containsKey(sessionID);
    }

    public static int numSessions() {
        return sessions.size();
    }

    public void setLogonTimeout(int seconds) {
        this.state.setLogonTimeout(seconds);
    }

    public void setLogoutTimeout(int seconds) {
        this.state.setLogoutTimeout(seconds);
    }
}

