/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLog;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class ScreenLogFactory
implements LogFactory {
    private SessionSettings settings;
    private boolean incoming;
    private boolean outgoing;
    private boolean events;
    private boolean heartBeats;
    public static final String SETTING_LOG_INCOMING = "ScreenLogShowIncoming";
    public static final String SETTING_LOG_OUTGOING = "ScreenLogShowOutgoing";
    public static final String SETTING_LOG_EVENTS = "ScreenLogShowEvents";
    public static final String SETTING_LOG_HEARTBEATS = "ScreenLogShowHeartBeats";

    public ScreenLogFactory(SessionSettings settings) {
        this(true, true, true);
        this.settings = settings;
    }

    public ScreenLogFactory(boolean incoming, boolean outgoing, boolean events) {
        this(incoming, outgoing, events, true);
    }

    public ScreenLogFactory(boolean incoming, boolean outgoing, boolean events, boolean logHeartBeats) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.events = events;
        this.heartBeats = logHeartBeats;
    }

    public Log create(SessionID sessionID) {
        try {
            this.incoming = this.getBooleanSetting(sessionID, SETTING_LOG_INCOMING, this.incoming);
            this.outgoing = this.getBooleanSetting(sessionID, SETTING_LOG_OUTGOING, this.outgoing);
            this.events = this.getBooleanSetting(sessionID, SETTING_LOG_EVENTS, this.events);
            this.heartBeats = this.getBooleanSetting(sessionID, SETTING_LOG_HEARTBEATS, this.heartBeats);
            return new ScreenLog(this.incoming, this.outgoing, this.events, this.heartBeats, sessionID, System.out);
        }
        catch (FieldConvertError e) {
            throw new RuntimeError(e);
        }
        catch (ConfigError e) {
            throw new RuntimeError(e);
        }
    }

    private boolean getBooleanSetting(SessionID sessionID, String key, boolean incoming) throws ConfigError, FieldConvertError {
        if (this.settings != null && this.settings.isSetting(sessionID, key)) {
            incoming = this.settings.getBool(sessionID, key);
        }
        return incoming;
    }
}

