/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.PrintStream;
import quickfix.InvalidMessage;
import quickfix.Log;
import quickfix.MessageUtils;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class ScreenLog
implements Log {
    private static final String EVENT_CATEGORY = "event";
    private static final String OUTGOING_CATEGORY = "outgoing";
    private static final String INCOMING_CATEGORY = "incoming";
    private PrintStream out;
    private final SessionID sessionID;
    private final boolean incoming;
    private final boolean outgoing;
    private final boolean events;
    private final boolean heartBeats;

    ScreenLog(boolean incoming, boolean outgoing, boolean events, boolean heartBeats, SessionID sessionID, PrintStream out) {
        this.out = out;
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.events = events;
        this.heartBeats = heartBeats;
        this.sessionID = sessionID;
    }

    public void onIncoming(String message) {
        if (this.incoming) {
            this.logMessage(message, INCOMING_CATEGORY);
        }
    }

    public void onOutgoing(String message) {
        if (this.outgoing) {
            this.logMessage(message, OUTGOING_CATEGORY);
        }
    }

    private void logMessage(String message, String type) {
        try {
            if (!this.heartBeats && "0".equals(MessageUtils.getMessageType(message))) {
                return;
            }
        }
        catch (InvalidMessage invalidMessage) {
            // empty catch block
        }
        this.log(message, type);
    }

    public void onEvent(String message) {
        if (this.events) {
            this.log(message, EVENT_CATEGORY);
        }
    }

    private void log(String message, String type) {
        this.out.println("<" + UtcTimestampConverter.convert(SystemTime.getDate(), false) + ", " + this.sessionID + ", " + type + "> (" + message + ")");
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    public void clear() {
        this.onEvent("Log clear operation is not supported: " + this.getClass().getName());
    }
}

