/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Log;
import quickfix.SessionID;

public class SLF4JLog
implements Log {
    public static final String DEFAULT_EVENT_CATEGORY = "quickfixj.event";
    public static final String DEFAULT_INCOMING_MSG_CATEGORY = "quickfixj.msg.incoming";
    public static final String DEFAULT_OUTGOING_MSG_CATEGORY = "quickfixj.msg.outgoing";
    private final Logger eventLog;
    private final Logger incomingMsgLog;
    private final Logger outgoingMsgLog;
    private final String logPrefix;
    private static final String FIX_MAJOR_VERSION_VAR = "\\$\\{fixMajorVersion}";
    private static final String FIX_MINOR_VERSION_VAR = "\\$\\{fixMinorVersion}";
    private static final String SENDER_COMP_ID_VAR = "\\$\\{senderCompID}";
    private static final String TARGET_COMP_ID_VAR = "\\$\\{targetCompID}";
    private static final String QUALIFIER_VAR = "\\$\\{qualifier}";

    public SLF4JLog(SessionID sessionID, String eventCategory, String incomingMsgCategory, String outgoingMsgCategory, boolean prependSessionID) {
        this.logPrefix = prependSessionID ? sessionID + ": " : null;
        this.eventLog = this.getLogger(sessionID, eventCategory, DEFAULT_EVENT_CATEGORY);
        this.incomingMsgLog = this.getLogger(sessionID, incomingMsgCategory, DEFAULT_INCOMING_MSG_CATEGORY);
        this.outgoingMsgLog = this.getLogger(sessionID, outgoingMsgCategory, DEFAULT_OUTGOING_MSG_CATEGORY);
    }

    private Logger getLogger(SessionID sessionID, String category, String defaultCategory) {
        return LoggerFactory.getLogger((String)(category != null ? this.substituteVariables(sessionID, category) : defaultCategory));
    }

    private String substituteVariables(SessionID sessionID, String category) {
        String[] beginStringFields = sessionID.getBeginString().split("\\.");
        String processedCategory = category;
        processedCategory = processedCategory.replaceAll(FIX_MAJOR_VERSION_VAR, beginStringFields[1]);
        processedCategory = processedCategory.replaceAll(FIX_MINOR_VERSION_VAR, beginStringFields[2]);
        processedCategory = processedCategory.replaceAll(SENDER_COMP_ID_VAR, sessionID.getSenderCompID());
        processedCategory = processedCategory.replaceAll(TARGET_COMP_ID_VAR, sessionID.getTargetCompID());
        processedCategory = processedCategory.replaceAll(QUALIFIER_VAR, sessionID.getSessionQualifier());
        return processedCategory;
    }

    public void onEvent(String text) {
        this.log(this.eventLog, text);
    }

    public void onIncoming(String message) {
        this.log(this.incomingMsgLog, message);
    }

    public void onOutgoing(String message) {
        this.log(this.outgoingMsgLog, message);
    }

    private void log(Logger log, String text) {
        log.info(this.logPrefix != null ? this.logPrefix + text : text);
    }

    public void clear() {
        this.onEvent("Log clear operation is not supported: " + this.getClass().getName());
    }
}

