/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import quickfix.MessageStore;
import quickfix.SystemTime;

public class MemoryStore
implements MessageStore {
    private HashMap messages = new HashMap();
    private int nextSenderMsgSeqNum;
    private int nextTargetMsgSeqNum;
    private Calendar creationTime = SystemTime.getUtcCalendar();

    public MemoryStore() throws IOException {
        this.reset();
    }

    public void get(int startSequence, int endSequence, Collection messages) throws IOException {
        for (int i = startSequence; i <= endSequence; ++i) {
            String message = (String)this.messages.get(new Integer(i));
            if (message == null) continue;
            messages.add(message);
        }
    }

    public boolean get(int sequence, String message) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public Date getCreationTime() throws IOException {
        return this.creationTime.getTime();
    }

    void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.nextSenderMsgSeqNum;
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.nextTargetMsgSeqNum;
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.setNextSenderMsgSeqNum(this.getNextSenderMsgSeqNum() + 1);
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.setNextTargetMsgSeqNum(this.getNextTargetMsgSeqNum() + 1);
    }

    public void reset() throws IOException {
        this.setNextSenderMsgSeqNum(1);
        this.setNextTargetMsgSeqNum(1);
        this.messages.clear();
        this.creationTime = SystemTime.getUtcCalendar();
    }

    public boolean set(int sequence, String message) throws IOException {
        return this.messages.put(new Integer(sequence), message) == null;
    }

    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.nextSenderMsgSeqNum = next;
    }

    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.nextTargetMsgSeqNum = next;
    }
}

