/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SessionSettings;

class JdbcUtil {
    static final String CONNECTION_POOL_ALIAS = "quickfixj";
    private static Map dataSources = new ConcurrentHashMap();
    private static int dataSourceCounter = 1;

    JdbcUtil() {
    }

    static SessionSettings convertMySQLStoreSettings(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        settings.setString(sessionID, "JdbcDriver", "com.mysql.jdbc.Driver");
        settings.setString(sessionID, "JdbcURL", "jdbc:mysql://" + settings.getString(sessionID, "MySQLStoreHost") + ":" + settings.getString(sessionID, "MySQLStorePort") + "/" + settings.getString(sessionID, "MySQLStoreDatabase"));
        settings.setString(sessionID, "JdbcUser", settings.getString(sessionID, "MySQLStoreUser"));
        settings.setString(sessionID, "JdbcPassword", settings.getString(sessionID, "MySQLStorePassword"));
        return settings;
    }

    static SessionSettings convertMySQLLogSettings(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        settings.setString(sessionID, "JdbcDriver", "com.mysql.jdbc.Driver");
        settings.setString(sessionID, "JdbcURL", "jdbc:mysql://" + settings.getString(sessionID, "MySQLLogHost") + ":" + settings.getString(sessionID, "MySQLLogPort") + "/" + settings.getString(sessionID, "MySQLLogDatabase"));
        settings.setString(sessionID, "JdbcUser", settings.getString(sessionID, "MySQLLogUser"));
        settings.setString(sessionID, "JdbcPassword", settings.getString(sessionID, "MySQLLogPassword"));
        return settings;
    }

    static DataSource getDataSource(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        if (settings.isSetting(sessionID, "JndiContextFactory") || settings.isSetting(sessionID, "JndiProviderURL") || settings.isSetting(sessionID, "JdbcDataSourceName")) {
            String jndiFactory = settings.getString(sessionID, "JndiContextFactory");
            String jndiURL = settings.getString(sessionID, "JndiProviderURL");
            String jndiName = settings.getString(sessionID, "JdbcDataSourceName");
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", jndiFactory);
                env.put("java.naming.provider.url", jndiURL);
                return (DataSource)new InitialContext(env).lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ConfigError(e);
            }
        }
        String jdbcDriver = settings.getString(sessionID, "JdbcDriver");
        String connectionURL = settings.getString(sessionID, "JdbcURL");
        String user = settings.getString(sessionID, "JdbcUser");
        String password = settings.getString(sessionID, "JdbcPassword");
        return JdbcUtil.getDataSource(jdbcDriver, connectionURL, user, password, true);
    }

    static DataSource getDataSource(String jdbcDriver, String connectionURL, String user, String password, boolean cache) {
        ProxoolDataSource ds;
        String key = jdbcDriver + "#" + connectionURL + "#" + user + "#" + password;
        ProxoolDataSource proxoolDataSource = ds = cache ? (ProxoolDataSource)dataSources.get(key) : null;
        if (ds == null) {
            ds = new ProxoolDataSource("quickfixj-" + dataSourceCounter++);
            ds.setDriver(jdbcDriver);
            ds.setDriverUrl(connectionURL);
            ds.setDelegateProperties("user=" + user + "," + (password != null && !"".equals(password) ? "password=" + password : ""));
            ds.setUser(user);
            ds.setPassword(password);
            ds.setMaximumActiveTime(5000);
            ds.setMaximumConnectionLifetime(28800000);
            ds.setMaximumConnectionCount(10);
            if (cache) {
                dataSources.put(key, ds);
            }
        }
        return ds;
    }

    static void close(SessionID sessionID, Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }

    static void close(SessionID sessionID, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }

    static void close(SessionID sessionID, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LogUtil.logThrowable(sessionID, e.getMessage(), (Throwable)e);
            }
        }
    }
}

