/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.sql.DataSource;
import quickfix.JdbcUtil;
import quickfix.MemoryStore;
import quickfix.RefreshableMessageStore;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

class JdbcStore
implements RefreshableMessageStore {
    private String sessionTableName = "sessions";
    private String messageTableName = "messages";
    private MemoryStore cache = new MemoryStore();
    private DataSource dataSource;
    private SessionID sessionID;
    private String SQL_UPDATE_SEQNUMS;
    private String SQL_INSERT_SESSION;
    private String SQL_GET_SEQNUMS;
    private String INSERT_UPDATE_MESSAGE;
    private String SQL_INSERT_MESSAGE;
    private String SQL_GET_MESSAGES;
    private String SQL_UPDATE_SESSION;
    private String SQL_DELETE_MESSAGES;

    public JdbcStore(SessionSettings settings, SessionID sessionID) throws Exception {
        this.sessionID = sessionID;
        if (settings.isSetting(sessionID, "JdbcStoreSessionsTableName")) {
            this.sessionTableName = settings.getString(sessionID, "JdbcStoreSessionsTableName");
        }
        if (settings.isSetting(sessionID, "JdbcStoreMessagesTableName")) {
            this.messageTableName = settings.getString(sessionID, "JdbcStoreMessagesTableName");
        }
        this.setSqlStrings();
        this.dataSource = JdbcUtil.getDataSource(settings, sessionID);
        this.loadCache();
    }

    private void setSqlStrings() {
        this.SQL_UPDATE_SEQNUMS = "UPDATE " + this.sessionTableName + " SET incoming_seqnum=?, " + "outgoing_seqnum=? WHERE beginstring=? and sendercompid=? " + "and targetcompid=? and session_qualifier=?";
        this.SQL_INSERT_SESSION = "INSERT INTO " + this.sessionTableName + " (beginstring, sendercompid, " + "targetcompid, session_qualifier, creation_time, " + "incoming_seqnum, outgoing_seqnum) VALUES(?,?,?,?,?,?,?)";
        this.SQL_GET_SEQNUMS = "SELECT creation_time, incoming_seqnum, outgoing_seqnum FROM " + this.sessionTableName + " WHERE beginstring=? and  " + "sendercompid=? and targetcompid=? and session_qualifier=?";
        this.INSERT_UPDATE_MESSAGE = "UPDATE " + this.messageTableName + " SET message=? " + "WHERE beginstring=? and sendercompid=? " + "and targetcompid=? and session_qualifier=? and msgseqnum=?";
        this.SQL_INSERT_MESSAGE = "INSERT INTO " + this.messageTableName + " (beginstring, " + "sendercompid, targetcompid, session_qualifier, msgseqnum, " + "message) VALUES (?,?,?,?,?,?)";
        this.SQL_GET_MESSAGES = "SELECT message FROM " + this.messageTableName + " WHERE  " + "beginstring=? and sendercompid=? and targetcompid=? and " + "session_qualifier=? and msgseqnum>=? and msgseqnum<=? " + "ORDER BY msgseqnum";
        this.SQL_UPDATE_SESSION = "UPDATE " + this.sessionTableName + " SET creation_time=?, " + "incoming_seqnum=?, outgoing_seqnum=? " + "WHERE beginstring=? and sendercompid=? and " + "targetcompid=? and session_qualifier=?";
        this.SQL_DELETE_MESSAGES = "DELETE FROM " + this.messageTableName + " WHERE " + "beginstring=? and sendercompid=? " + "and targetcompid=? and session_qualifier=?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws SQLException, IOException {
        Connection connection = null;
        PreparedStatement query = null;
        PreparedStatement insert = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            query = connection.prepareStatement(this.SQL_GET_SEQNUMS);
            query.setString(1, this.sessionID.getBeginString());
            query.setString(2, this.sessionID.getSenderCompID());
            query.setString(3, this.sessionID.getTargetCompID());
            query.setString(4, this.sessionID.getSessionQualifier());
            rs = query.executeQuery();
            if (rs.next()) {
                this.cache.setCreationTime(SystemTime.getUtcCalendar(rs.getTimestamp(1)));
                this.cache.setNextTargetMsgSeqNum(rs.getInt(2));
                this.cache.setNextSenderMsgSeqNum(rs.getInt(3));
            } else {
                insert = connection.prepareStatement(this.SQL_INSERT_SESSION);
                insert.setString(1, this.sessionID.getBeginString());
                insert.setString(2, this.sessionID.getSenderCompID());
                insert.setString(3, this.sessionID.getTargetCompID());
                insert.setString(4, this.sessionID.getSessionQualifier());
                insert.setTimestamp(5, new Timestamp(this.cache.getCreationTime().getTime()));
                insert.setInt(6, this.cache.getNextTargetMsgSeqNum());
                insert.setInt(7, this.cache.getNextSenderMsgSeqNum());
                insert.execute();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JdbcUtil.close(this.sessionID, rs);
            JdbcUtil.close(this.sessionID, query);
            JdbcUtil.close(this.sessionID, insert);
            JdbcUtil.close(this.sessionID, connection);
            throw throwable;
        }
        JdbcUtil.close(this.sessionID, rs);
        JdbcUtil.close(this.sessionID, query);
        JdbcUtil.close(this.sessionID, insert);
        JdbcUtil.close(this.sessionID, connection);
    }

    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.setNextSenderMsgSeqNum(this.cache.getNextSenderMsgSeqNum());
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.setNextTargetMsgSeqNum(this.cache.getNextTargetMsgSeqNum());
    }

    public void reset() throws IOException {
        this.cache.reset();
        Connection connection = null;
        PreparedStatement deleteMessages = null;
        PreparedStatement updateTime = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                deleteMessages = connection.prepareStatement(this.SQL_DELETE_MESSAGES);
                deleteMessages.setString(1, this.sessionID.getBeginString());
                deleteMessages.setString(2, this.sessionID.getSenderCompID());
                deleteMessages.setString(3, this.sessionID.getTargetCompID());
                deleteMessages.setString(4, this.sessionID.getSessionQualifier());
                deleteMessages.execute();
                updateTime = connection.prepareStatement(this.SQL_UPDATE_SESSION);
                updateTime.setTimestamp(1, new Timestamp(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis()));
                updateTime.setInt(2, this.getNextTargetMsgSeqNum());
                updateTime.setInt(3, this.getNextSenderMsgSeqNum());
                updateTime.setString(4, this.sessionID.getBeginString());
                updateTime.setString(5, this.sessionID.getSenderCompID());
                updateTime.setString(6, this.sessionID.getTargetCompID());
                updateTime.setString(7, this.sessionID.getSessionQualifier());
                updateTime.execute();
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (IOException e) {
                throw e;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            JdbcUtil.close(this.sessionID, deleteMessages);
            JdbcUtil.close(this.sessionID, updateTime);
            JdbcUtil.close(this.sessionID, connection);
            throw throwable;
        }
        JdbcUtil.close(this.sessionID, deleteMessages);
        JdbcUtil.close(this.sessionID, updateTime);
        JdbcUtil.close(this.sessionID, connection);
    }

    public void get(int startSequence, int endSequence, Collection messages) throws IOException {
        Connection connection = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                query = connection.prepareStatement(this.SQL_GET_MESSAGES);
                query.setString(1, this.sessionID.getBeginString());
                query.setString(2, this.sessionID.getSenderCompID());
                query.setString(3, this.sessionID.getTargetCompID());
                query.setString(4, this.sessionID.getSessionQualifier());
                query.setInt(5, startSequence);
                query.setInt(6, endSequence);
                rs = query.executeQuery();
                while (rs.next()) {
                    String message = rs.getString(1);
                    messages.add(message);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            JdbcUtil.close(this.sessionID, rs);
            JdbcUtil.close(this.sessionID, query);
            JdbcUtil.close(this.sessionID, connection);
            throw throwable;
        }
        JdbcUtil.close(this.sessionID, rs);
        JdbcUtil.close(this.sessionID, query);
        JdbcUtil.close(this.sessionID, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(int sequence, String message) throws IOException {
        Connection connection = null;
        PreparedStatement insert = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                insert = connection.prepareStatement(this.SQL_INSERT_MESSAGE);
                insert.setString(1, this.sessionID.getBeginString());
                insert.setString(2, this.sessionID.getSenderCompID());
                insert.setString(3, this.sessionID.getTargetCompID());
                insert.setString(4, this.sessionID.getSessionQualifier());
                insert.setInt(5, sequence);
                insert.setString(6, message);
                insert.execute();
            }
            catch (SQLException ex) {
                boolean bl;
                if (connection == null) {
                    Object var11_8 = null;
                    JdbcUtil.close(this.sessionID, rs);
                    JdbcUtil.close(this.sessionID, insert);
                    JdbcUtil.close(this.sessionID, connection);
                    return true;
                }
                PreparedStatement update = null;
                try {
                    update = connection.prepareStatement(this.INSERT_UPDATE_MESSAGE);
                    update.setString(1, this.sessionID.getBeginString());
                    update.setString(2, this.sessionID.getSenderCompID());
                    update.setString(3, this.sessionID.getTargetCompID());
                    update.setString(4, this.sessionID.getSessionQualifier());
                    update.setInt(5, sequence);
                    update.setString(6, message);
                    update.execute();
                    bl = false;
                    Object var11_7 = null;
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
                JdbcUtil.close(this.sessionID, rs);
                JdbcUtil.close(this.sessionID, insert);
                JdbcUtil.close(this.sessionID, connection);
                return bl;
                finally {
                    JdbcUtil.close(this.sessionID, update);
                }
            }
            Object var11_6 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            JdbcUtil.close(this.sessionID, rs);
            JdbcUtil.close(this.sessionID, insert);
            JdbcUtil.close(this.sessionID, connection);
            throw throwable;
        }
        JdbcUtil.close(this.sessionID, rs);
        JdbcUtil.close(this.sessionID, insert);
        JdbcUtil.close(this.sessionID, connection);
        return true;
    }

    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    private void storeSequenceNumbers() throws IOException {
        Connection connection = null;
        PreparedStatement update = null;
        try {
            connection = this.dataSource.getConnection();
            update = connection.prepareStatement(this.SQL_UPDATE_SEQNUMS);
            update.setInt(1, this.cache.getNextTargetMsgSeqNum());
            update.setInt(2, this.cache.getNextSenderMsgSeqNum());
            update.setString(3, this.sessionID.getBeginString());
            update.setString(4, this.sessionID.getSenderCompID());
            update.setString(5, this.sessionID.getTargetCompID());
            update.setString(6, this.sessionID.getSessionQualifier());
            update.execute();
        }
        catch (SQLException e) {
            try {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, update);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
        }
        JdbcUtil.close(this.sessionID, update);
        JdbcUtil.close(this.sessionID, connection);
    }

    public void setSessionTableName(String sessionTableName) {
        this.sessionTableName = sessionTableName;
        this.setSqlStrings();
    }

    public void setMessageTableName(String messageTableName) {
        this.messageTableName = messageTableName;
        this.setSqlStrings();
    }

    public void refresh() throws IOException {
        try {
            this.loadCache();
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    DataSource getDataSource() {
        return this.dataSource;
    }
}

