/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.FileStore;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class FileStoreFactory
implements MessageStoreFactory {
    public static final String SETTING_FILE_STORE_PATH = "FileStorePath";
    public static final String SETTING_FILE_STORE_SYNC = "FileStoreSync";
    private final SessionSettings settings;

    public FileStoreFactory(SessionSettings settings) {
        this.settings = settings;
    }

    public MessageStore create(SessionID sessionID) {
        try {
            boolean syncWrites = false;
            if (this.settings.isSetting(sessionID, SETTING_FILE_STORE_SYNC)) {
                syncWrites = this.settings.getBool(sessionID, SETTING_FILE_STORE_SYNC);
            }
            return new FileStore(this.settings.getString(sessionID, SETTING_FILE_STORE_PATH), sessionID, syncWrites);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

