/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.FileLog;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.RuntimeError;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class FileLogFactory
implements LogFactory {
    public static final String SETTING_FILE_LOG_PATH = "FileLogPath";
    public static final String SETTING_INCLUDE_MILLIS_IN_TIMESTAMP = "FileIncludeMilliseconds";
    public static final String SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES = "FileIncludeTimeStampForMessages";
    private SessionSettings settings;

    public FileLogFactory(SessionSettings settings) {
        this.settings = settings;
    }

    public Log create(SessionID sessionID) {
        try {
            boolean includeMillis = false;
            if (this.settings.isSetting(sessionID, SETTING_INCLUDE_MILLIS_IN_TIMESTAMP)) {
                includeMillis = this.settings.getBool(sessionID, SETTING_INCLUDE_MILLIS_IN_TIMESTAMP);
            }
            boolean includeTimestampInMessages = false;
            if (this.settings.isSetting(sessionID, SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES)) {
                includeTimestampInMessages = this.settings.getBool(sessionID, SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES);
            }
            return new FileLog(this.settings.getString(sessionID, SETTING_FILE_LOG_PATH), sessionID, includeMillis, includeTimestampInMessages);
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }
}

