/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Hashtable;
import java.util.Map;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DefaultMessageFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSchedule;
import quickfix.SessionSettings;

public class DefaultSessionFactory
implements SessionFactory {
    private static Map dictionaryCache = new Hashtable();
    private Application application;
    private MessageStoreFactory messageStoreFactory;
    private LogFactory logFactory;
    private MessageFactory messageFactory;

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = new DefaultMessageFactory();
    }

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = messageFactory;
    }

    public Session create(SessionID sessionID, SessionSettings settings) throws ConfigError {
        try {
            String connectionType = null;
            if (settings.isSetting(sessionID, "ConnectionType")) {
                connectionType = settings.getString(sessionID, "ConnectionType");
            }
            if (connectionType == null) {
                throw new ConfigError("Missing ConnectionType");
            }
            if (!connectionType.equals("acceptor") && !connectionType.equals("initiator")) {
                throw new ConfigError("Invalid ConnectionType");
            }
            if (connectionType.equals("acceptor") && settings.isSetting(sessionID, "SessionQualifier")) {
                throw new ConfigError("SessionQualifier cannot be used with acceptor.");
            }
            boolean useDataDictionary = true;
            if (settings.isSetting(sessionID, "UseDataDictionary")) {
                useDataDictionary = settings.getBool(sessionID, "UseDataDictionary");
            }
            DataDictionary dataDictionary = null;
            if (useDataDictionary) {
                String path = null;
                path = settings.isSetting(sessionID, "DataDictionary") ? settings.getString(sessionID, "DataDictionary") : settings.getString(sessionID, "BeginString").replaceAll("\\.", "") + ".xml";
                dataDictionary = (DataDictionary)dictionaryCache.get(path);
                if (dataDictionary == null) {
                    dataDictionary = new DataDictionary(path);
                    dictionaryCache.put(path, dataDictionary);
                }
                if (settings.isSetting(sessionID, "ValidateFieldsOutOfOrder")) {
                    dataDictionary.setCheckFieldsOutOfOrder(settings.getBool(sessionID, "ValidateFieldsOutOfOrder"));
                }
                if (settings.isSetting(sessionID, "ValidateFieldsHaveValues")) {
                    dataDictionary.setCheckFieldsHaveValues(settings.getBool(sessionID, "ValidateFieldsHaveValues"));
                }
                if (settings.isSetting(sessionID, "ValidateUserDefinedFields")) {
                    dataDictionary.setCheckUserDefinedFields(settings.getBool(sessionID, "ValidateUserDefinedFields"));
                }
            }
            int heartbeatInterval = 0;
            if (connectionType.equals("initiator") && (heartbeatInterval = (int)settings.getLong(sessionID, "HeartBtInt")) <= 0) {
                throw new ConfigError("Heartbeat must be greater than zero");
            }
            Session session = new Session(this.application, this.messageStoreFactory, sessionID, dataDictionary, new SessionSchedule(settings, sessionID), this.logFactory, this.messageFactory, heartbeatInterval);
            if (settings.isSetting(sessionID, "CheckLatency")) {
                session.setCheckLatency(settings.getBool(sessionID, "CheckLatency"));
            }
            if (settings.isSetting(sessionID, "MaxLatency")) {
                session.setMaxLatency((int)settings.getLong(sessionID, "MaxLatency"));
            }
            if (settings.isSetting(sessionID, "ResetOnLogout")) {
                session.setResetOnLogout(settings.getBool(sessionID, "ResetOnLogout"));
            }
            if (settings.isSetting(sessionID, "ResetOnDisconnect")) {
                session.setResetOnDisconnect(settings.getBool(sessionID, "ResetOnDisconnect"));
            }
            if (settings.isSetting(sessionID, "MillisecondsInTimeStamp")) {
                session.setMillisecondsInTimestamp(settings.getBool(sessionID, "MillisecondsInTimeStamp"));
            }
            if (settings.isSetting(sessionID, "SendResetSeqNumFlag")) {
                session.setResetWhenInitiatingLogon(settings.getBool(sessionID, "SendResetSeqNumFlag"));
            }
            if (settings.isSetting(sessionID, "RefreshMessageStoreAtLogon")) {
                session.setRefreshMessageStoreAtLogon(settings.getBool(sessionID, "RefreshMessageStoreAtLogon"));
            }
            if (settings.isSetting(sessionID, "LogonTimeout")) {
                session.setLogonTimeout((int)settings.getLong(sessionID, "LogonTimeout"));
            }
            if (settings.isSetting(sessionID, "LogoutTimeout")) {
                session.setLogoutTimeout((int)settings.getLong(sessionID, "LogoutTimeout"));
            }
            return session;
        }
        catch (ConfigError e) {
            throw e;
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e.getMessage());
        }
    }
}

