/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.toolkit;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.SchedulerCallbackIF;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Scheduler {
    private Timer timer;
    private SchedulerCallbackIF callback;
    private Map<ChannelIF, SchedulerTask> timers = new IdentityHashMap<ChannelIF, SchedulerTask>();

    public Scheduler(SchedulerCallbackIF callback) {
        this.callback = callback;
        this.timer = new Timer(true);
    }

    public final void schedule(ChannelIF channel, long period, int priority) {
        this.schedule(channel, 0L, period, priority);
    }

    public final void schedule(ChannelIF channel, long delay, long period, int priority) {
        if (channel != null) {
            ChannelRecord record = new ChannelRecord(channel, period, priority);
            this.unschedule(channel);
            this.sched(record, delay, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unschedule(ChannelIF channel) {
        ChannelRecord record = null;
        Map<ChannelIF, SchedulerTask> map = this.timers;
        synchronized (map) {
            SchedulerTask tt = this.timers.get(channel);
            if (tt != null) {
                this.timers.remove(channel);
                tt.cancel();
                record = tt.getRecord();
                record.setCanceled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void triggerNow(ChannelIF channel) {
        SchedulerTask task;
        Map<ChannelIF, SchedulerTask> map = this.timers;
        synchronized (map) {
            task = this.timers.get(channel);
        }
        if (task != null) {
            ChannelRecord record = task.getRecord();
            this.resched(record, record.getPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rescheduleAll(long period) {
        ChannelIF[] channels;
        Map<ChannelIF, SchedulerTask> map = this.timers;
        synchronized (map) {
            channels = this.timers.keySet().toArray(new ChannelIF[0]);
        }
        for (int i = 0; i < channels.length; ++i) {
            ChannelIF channel = channels[i];
            this.rescheduleChannel(channel, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rescheduleChannel(ChannelIF channel, long period) {
        SchedulerTask task = this.timers.get(channel);
        if (task == null) {
            this.schedule(channel, period, 0);
        } else {
            ChannelRecord record = task.getRecord();
            Map<ChannelIF, SchedulerTask> map = this.timers;
            synchronized (map) {
                this.timers.remove(channel);
            }
            task.cancel();
            long timePassed = System.currentTimeMillis() - task.scheduledExecutionTime();
            long delay = 0L;
            if (timePassed >= 0L && (delay = period - timePassed) < 0L) {
                delay = 0L;
            }
            this.sched(record, delay, period);
        }
    }

    private void resched(ChannelRecord record, long period) {
        ChannelIF channel = record.getChannel();
        this.unschedule(channel);
        this.sched(record, 0L, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(ChannelRecord record, long delay, long period) {
        record.setCanceled(false);
        ChannelIF channel = record.getChannel();
        SchedulerTask tt = new SchedulerTask(record);
        Map<ChannelIF, SchedulerTask> map = this.timers;
        synchronized (map) {
            this.timers.put(channel, tt);
        }
        this.timer.schedule((TimerTask)tt, delay, period);
    }

    private class SchedulerTask
    extends TimerTask {
        private ChannelRecord record;

        public SchedulerTask(ChannelRecord record) {
            this.record = record;
        }

        public void run() {
            Scheduler.this.callback.process(this.record);
        }

        public ChannelRecord getRecord() {
            return this.record;
        }
    }
}

