/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.poller;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import de.nava.informa.utils.poller.PollerObserverIF;

public class PersistenceObserver
implements PollerObserverIF {
    private PersistenceManagerIF manager;

    public PersistenceObserver(PersistenceManagerIF manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Manager should be specified.");
        }
        this.manager = manager;
    }

    public final void itemFound(ItemIF item, ChannelIF channel) {
        try {
            this.manager.createItem(channel, item);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            // empty catch block
        }
    }

    public void channelErrored(ChannelIF channel, Exception e) {
    }

    public void channelChanged(ChannelIF channel) {
        try {
            this.manager.updateChannel(channel);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            // empty catch block
        }
    }

    public void pollStarted(ChannelIF channel) {
    }

    public void pollFinished(ChannelIF channel) {
    }
}

