/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.poller;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.poller.PollerObserverIF;
import java.util.List;
import java.util.Vector;

class CompositeObserver
implements PollerObserverIF {
    private List<PollerObserverIF> observers = new Vector<PollerObserverIF>();

    CompositeObserver() {
    }

    public final void itemFound(ItemIF item, ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            PollerObserverIF observer = this.observers.get(i);
            try {
                observer.itemFound(item, channel);
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    public final void channelErrored(ChannelIF channel, Exception e) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            PollerObserverIF observer = this.observers.get(i);
            try {
                observer.channelErrored(channel, e);
                continue;
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
        }
    }

    public final void channelChanged(ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            PollerObserverIF observer = this.observers.get(i);
            try {
                observer.channelChanged(channel);
                continue;
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
        }
    }

    public final void pollStarted(ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            PollerObserverIF observer = this.observers.get(i);
            try {
                observer.pollStarted(channel);
                continue;
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
        }
    }

    public final void pollFinished(ChannelIF channel) {
        int size = this.observers.size();
        for (int i = 0; i < size; ++i) {
            PollerObserverIF observer = this.observers.get(i);
            try {
                observer.pollFinished(channel);
                continue;
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
        }
    }

    public final void add(PollerObserverIF observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public final void remove(PollerObserverIF observer) {
        this.observers.remove(observer);
    }
}

