/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.manager.hibernate;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.hibernate.NonCachingPersistenceManager;
import java.util.HashMap;
import java.util.Map;

public class PersistenceManager
extends NonCachingPersistenceManager {
    private Map<Long, ChannelGroupIF> groups = new HashMap<Long, ChannelGroupIF>();
    private boolean groupsRead = false;

    public ChannelGroupIF createGroup(String title) throws PersistenceManagerException {
        ChannelGroupIF group = super.createGroup(title);
        this.groups.put(new Long(group.getId()), group);
        return group;
    }

    public void deleteGroup(ChannelGroupIF group) throws PersistenceManagerException {
        long groupId = group.getId();
        super.deleteGroup(group);
        if (groupId > -1L) {
            this.groups.remove(new Long(groupId));
        }
    }

    public void mergeGroups(ChannelGroupIF first, ChannelGroupIF second) throws PersistenceManagerException {
        long groupId = second.getId();
        super.mergeGroups(first, second);
        if (groupId > -1L) {
            this.groups.remove(new Long(groupId));
        }
    }

    public ChannelGroupIF[] getGroups() throws PersistenceManagerException {
        if (!this.groupsRead) {
            ChannelGroupIF[] hibernateGroups = super.getGroups();
            for (int i = 0; i < hibernateGroups.length; ++i) {
                ChannelGroupIF hibernateGroup = hibernateGroups[i];
                Long groupId = new Long(hibernateGroup.getId());
                if (this.groups.containsKey(groupId)) continue;
                this.groups.put(groupId, hibernateGroup);
            }
            this.groupsRead = true;
        }
        return this.groups.values().toArray(new ChannelGroupIF[0]);
    }
}

