/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.manager.hibernate;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.impl.hibernate.Item;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import de.nava.informa.utils.manager.hibernate.HibernateUtil;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

class NonCachingPersistenceManager
implements PersistenceManagerIF {
    private static final Logger LOG = Logger.getLogger(NonCachingPersistenceManager.class.getName());

    NonCachingPersistenceManager() {
    }

    public ChannelGroupIF createGroup(String title) throws PersistenceManagerException {
        ChannelGroup group = new ChannelGroup(title);
        HibernateUtil.saveObject(group);
        return group;
    }

    public void updateGroup(ChannelGroupIF group) throws PersistenceManagerException {
        HibernateUtil.updateObject(group);
    }

    public void deleteGroup(ChannelGroupIF group) throws PersistenceManagerException {
        NonCachingPersistenceManager.deleteGroup(group, null);
        group.setId(-1L);
    }

    public void mergeGroups(ChannelGroupIF first, ChannelGroupIF second) throws PersistenceManagerException {
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            HibernateUtil.lock(first, session);
            HibernateUtil.lock(second, session);
            NonCachingPersistenceManager.mergeGroups(first, second, session);
            tx.commit();
            second.setId(-1L);
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could not merge groups.", e);
            throw new PersistenceManagerException("Could not merge groups.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    public ChannelGroupIF[] getGroups() throws PersistenceManagerException {
        ChannelGroupIF[] groups = null;
        try {
            Session session = HibernateUtil.openSession();
            groups = NonCachingPersistenceManager.getGroups(session);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not read the list of groups.", e);
            throw new PersistenceManagerException("Could not read the list of groups.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
        return groups == null ? new ChannelGroupIF[]{} : groups;
    }

    public ChannelIF createChannel(String title, URL location) throws PersistenceManagerException {
        Channel channel = new Channel(title);
        channel.setLocation(location);
        HibernateUtil.saveObject(channel);
        return channel;
    }

    public void updateChannel(ChannelIF channel) throws PersistenceManagerException {
        HibernateUtil.updateObject(channel);
    }

    public void addChannelToGroup(ChannelIF channel, ChannelGroupIF group) throws PersistenceManagerException {
        channel.hashCode();
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            HibernateUtil.lock(channel, session);
            group.add(channel);
            HibernateUtil.updateObject(group, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could add channel to group.", e);
            throw new PersistenceManagerException("Could add channel to group.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    public void removeChannelFromGroup(ChannelIF channel, ChannelGroupIF group) throws PersistenceManagerException {
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            HibernateUtil.lock(channel, session);
            group.remove(channel);
            HibernateUtil.updateObject(group, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could add channel to group.", e);
            throw new PersistenceManagerException("Could add channel to group.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    public void deleteChannel(ChannelIF channel) throws PersistenceManagerException {
        ChannelGroupIF[] groups = this.getGroups();
        ItemIF[] items = null;
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            HibernateUtil.lock(channel, session);
            items = this.deleteChannel(channel, groups, session);
            tx.commit();
            channel.setId(-1L);
            for (int i = 0; i < items.length; ++i) {
                items[i].setId(-1L);
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could not delete channel.", e);
            throw new PersistenceManagerException("Could not delete channel.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    public ItemIF createItem(ChannelIF channel, String title) throws PersistenceManagerException {
        Item item = new Item(channel, title, null, null);
        this.saveCreatedItem(channel, item);
        return item;
    }

    public ItemIF createItem(ChannelIF channel, ItemIF ethalon) throws PersistenceManagerException {
        Item item = new Item(channel, null, null, null);
        InformaUtils.copyItemProperties(ethalon, item);
        this.saveCreatedItem(channel, item);
        return item;
    }

    public void updateItem(ItemIF item) throws PersistenceManagerException {
        HibernateUtil.updateObject(item);
    }

    public void deleteItem(ItemIF item) throws PersistenceManagerException {
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            NonCachingPersistenceManager.deleteItem(item, session);
            tx.commit();
            item.setId(-1L);
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could not delete item.", e);
            throw new PersistenceManagerException("Could not delete item.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    private static void mergeGroups(ChannelGroupIF first, ChannelGroupIF second, Session session) throws PersistenceManagerException {
        first.getAll().addAll(second.getAll());
        HibernateUtil.updateObject(first, session);
        NonCachingPersistenceManager.deleteGroup(second, session);
    }

    private static void deleteGroup(ChannelGroupIF group, Session session) throws PersistenceManagerException {
        if (session != null) {
            HibernateUtil.lock(group, session);
        }
        group.getAll().clear();
        HibernateUtil.deleteObject(group, session);
    }

    private static ChannelGroupIF[] getGroups(Session session) throws PersistenceManagerException {
        ChannelGroupIF[] groups;
        try {
            List groupsList = session.createQuery("from ChannelGroup").list();
            groups = groupsList.toArray(new ChannelGroupIF[0]);
            for (int i = 0; i < groups.length; ++i) {
                ChannelGroupIF group = groups[i];
                NonCachingPersistenceManager.initGroupCollections(group);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not read the list of groups.", e);
            throw new PersistenceManagerException("Could not read the list of groups.", e);
        }
        return groups;
    }

    private static void initGroupCollections(ChannelGroupIF group) {
        group.getChildren().size();
        ChannelIF[] channels = group.getAll().toArray(new ChannelIF[0]);
        for (int i = 0; i < channels.length; ++i) {
            ChannelIF channel = channels[i];
            channel.getCategories().size();
            ((Channel)channel).getGroups().size();
            Iterator<ItemIF> it = channel.getItems().iterator();
            while (it.hasNext()) {
                it.next().getCategories().size();
            }
        }
    }

    private ItemIF[] deleteChannel(ChannelIF channel, ChannelGroupIF[] groups, Session session) throws PersistenceManagerException {
        for (int i = 0; i < groups.length; ++i) {
            ChannelGroupIF group = groups[i];
            if (!group.getAll().contains(channel)) continue;
            group.remove(channel);
            HibernateUtil.updateObject(group, session);
        }
        ItemIF[] items = channel.getItems().toArray(new ItemIF[0]);
        for (int i = 0; i < items.length; ++i) {
            ItemIF item = items[i];
            channel.removeItem(item);
            HibernateUtil.deleteObject(item, session);
        }
        HibernateUtil.deleteObject(channel, session);
        return items;
    }

    private static void createItem(ItemIF item, ChannelIF channel, Session session) throws PersistenceManagerException {
        channel.addItem(item);
    }

    private static void deleteItem(ItemIF item, Session session) throws PersistenceManagerException {
        ChannelIF channel = item.getChannel();
        if (channel != null) {
            HibernateUtil.lock(channel, session);
            channel.removeItem(item);
        } else {
            LOG.severe("Item didn't belong to any channel: " + item);
        }
        HibernateUtil.deleteObject(item, session);
    }

    private void saveCreatedItem(ChannelIF channel, ItemIF item) throws PersistenceManagerException {
        Transaction tx = null;
        try {
            Session session = HibernateUtil.openSession();
            tx = session.beginTransaction();
            HibernateUtil.lock(channel, session);
            NonCachingPersistenceManager.createItem(item, channel, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Could not create item.", e);
            throw new PersistenceManagerException("Could not create item.", e);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }
}

