/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.manager.hibernate;

import de.nava.informa.impl.hibernate.SessionHandler;
import de.nava.informa.utils.manager.PersistenceManagerException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import sun.misc.Lock;

final class HibernateUtil {
    private static final Logger LOG = Logger.getLogger(HibernateUtil.class.getName());
    private static final ThreadLocal<Session> SESSION = new ThreadLocal();
    private static SessionHandler sessionHandler;
    private static boolean inited;
    private static Lock lock;

    private HibernateUtil() {
    }

    private static synchronized void init() throws HibernateException {
        sessionHandler = SessionHandler.getInstance(System.getProperties());
        inited = true;
    }

    public static Session openSession() throws HibernateException {
        Session s;
        if (!inited) {
            HibernateUtil.init();
        }
        if ((s = SESSION.get()) != null) {
            LOG.log(Level.WARNING, "Openning session more than once from the same thread!", new Exception("Dump"));
            s.clear();
            return s;
        }
        try {
            lock.lock();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for session.");
        }
        s = sessionHandler.getSession();
        SESSION.set(s);
        return s;
    }

    public static void closeSession() {
        Session s = SESSION.get();
        SESSION.set(null);
        if (s != null) {
            try {
                s.close();
            }
            catch (HibernateException e) {
                LOG.log(Level.SEVERE, "Could not close session.", e);
            }
            lock.unlock();
        } else {
            LOG.log(Level.SEVERE, "Broken sequence of calls. Session is not opened or already closed.");
            try {
                throw new NullPointerException();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    public static void lock(Object o, Session s) {
        try {
            s.lock(o, LockMode.NONE);
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
    }

    public static void saveObject(Object object) throws PersistenceManagerException {
        HibernateUtil.saveObject(object, null);
    }

    public static void saveObject(Object object, Session session) throws PersistenceManagerException {
        boolean isForeignSession = session != null;
        try {
            if (!isForeignSession) {
                session = HibernateUtil.openSession();
            }
            session.save(object);
            if (!isForeignSession) {
                session.flush();
                session.connection().commit();
            }
        }
        catch (Exception e) {
            if (!isForeignSession) {
                try {
                    session.connection().rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Couldn't save object.", e);
            throw new PersistenceManagerException("Couldn't save object.", e);
        }
        finally {
            if (!isForeignSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    public static void updateObject(Object object) throws PersistenceManagerException {
        HibernateUtil.updateObject(object, null);
    }

    public static void updateObject(Object object, Session session) throws PersistenceManagerException {
        boolean isForeignSession = session != null;
        try {
            if (!isForeignSession) {
                session = HibernateUtil.openSession();
            }
            session.update(object);
            if (!isForeignSession) {
                session.flush();
                session.connection().commit();
            }
        }
        catch (Exception e) {
            if (!isForeignSession) {
                try {
                    session.connection().rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Couldn't update object.", e);
            throw new PersistenceManagerException("Couldn't update object.", e);
        }
        finally {
            if (!isForeignSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    public static void deleteObject(Object object, Session session) throws PersistenceManagerException {
        boolean isForeignSession = session != null;
        try {
            if (!isForeignSession) {
                session = HibernateUtil.openSession();
            }
            session.delete(object);
            if (!isForeignSession) {
                session.flush();
                session.connection().commit();
            }
        }
        catch (Exception e) {
            if (!isForeignSession) {
                try {
                    session.connection().rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "Couldn't delete object.", e);
            throw new PersistenceManagerException("Couldn't delete object.", e);
        }
        finally {
            if (!isForeignSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    static {
        inited = false;
        lock = new Lock();
    }
}

