/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils.cleaner;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.cleaner.CleanerMatcherIF;
import de.nava.informa.utils.cleaner.CleanerObserverIF;
import de.nava.informa.utils.cleaner.CleanerWorkerThread;
import de.nava.informa.utils.cleaner.CompositeMatcher;
import de.nava.informa.utils.cleaner.CompositeObserver;
import de.nava.informa.utils.toolkit.ChannelRecord;
import de.nava.informa.utils.toolkit.Scheduler;
import de.nava.informa.utils.toolkit.SchedulerCallbackIF;
import de.nava.informa.utils.toolkit.WorkerThread;
import de.nava.informa.utils.toolkit.WorkerThreadFactoryIF;
import de.nava.informa.utils.toolkit.WorkersManager;

public class Cleaner {
    private static final long DEFAULT_CLEANING_PERIOD = 3600000L;
    private static final int DEFAULT_WORKER_THREADS = 2;
    private WorkersManager workersManager;
    private Scheduler scheduler;
    private CompositeObserver compositeObserver;
    private CompositeMatcher compositeMatcher = new CompositeMatcher();
    private long globalPollPeriod = 3600000L;

    public Cleaner() {
        this(2);
    }

    public Cleaner(int workerThreads) {
        this.compositeObserver = new CompositeObserver();
        this.workersManager = new WorkersManager(new CleanerThreadFactory(), workerThreads);
        this.scheduler = new Scheduler(new SchedulerCallback());
    }

    public final void addObserver(CleanerObserverIF observer) {
        this.compositeObserver.add(observer);
    }

    public final void addMatcher(CleanerMatcherIF matcher) {
        this.compositeMatcher.add(matcher);
    }

    public final void removeObserver(CleanerObserverIF observer) {
        this.compositeObserver.remove(observer);
    }

    public final void removeMatcher(CleanerMatcherIF matcher) {
        this.compositeMatcher.remove(matcher);
    }

    public final void registerChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.schedule(channel, this.globalPollPeriod, 0);
        }
    }

    public final void registerChannel(ChannelIF channel, long period) {
        if (channel != null) {
            this.scheduler.schedule(channel, period, 0);
        }
    }

    public final void unregisterChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.unschedule(channel);
        }
    }

    public final void cleanChannel(ChannelIF channel) {
        if (channel != null) {
            this.scheduler.triggerNow(channel);
        }
    }

    public final void setWorkerThreads(int count) {
        this.workersManager.setWorkerThreads(count);
    }

    public final void setPeriod(long period) {
        this.globalPollPeriod = period;
        this.scheduler.rescheduleAll(period);
    }

    private class SchedulerCallback
    implements SchedulerCallbackIF {
        private SchedulerCallback() {
        }

        public void process(ChannelRecord record) {
            Cleaner.this.workersManager.process(record);
        }
    }

    private class CleanerThreadFactory
    implements WorkerThreadFactoryIF {
        private CleanerThreadFactory() {
        }

        public WorkerThread create() {
            return new CleanerWorkerThread(Cleaner.this.compositeObserver, Cleaner.this.compositeMatcher);
        }
    }
}

