/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.ChannelRegistry;
import de.nava.informa.utils.FormatDetector;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.UpdateChannelInfo;
import java.io.IOException;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateChannelTask
extends TimerTask {
    private static Log logger = LogFactory.getLog(UpdateChannelTask.class);
    private ChannelRegistry registry;
    private ChannelIF channel;
    private ChannelBuilderIF builder;
    private UpdateChannelInfo info;
    private ChannelBuilderIF tempBuilder;

    public UpdateChannelTask(ChannelRegistry registry, ChannelBuilderIF builder, ChannelIF channel, UpdateChannelInfo info) {
        this.registry = registry;
        this.channel = channel;
        this.builder = builder;
        this.info = info;
        this.tempBuilder = new ChannelBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.info((Object)"Task Run()");
        Thread.currentThread().setName("Informa Update Channel Task");
        ChannelBuilderIF channelBuilderIF = this.builder;
        synchronized (channelBuilderIF) {
            if (!this.info.getFormatDetected()) {
                try {
                    this.builder.beginTransaction();
                    ChannelFormat format = FormatDetector.getFormat(this.channel.getLocation());
                    this.channel.setFormat(format);
                    this.info.setFormatDetected(true);
                    this.channel.setLastUpdated(new Date());
                    this.builder.endTransaction();
                }
                catch (UnsupportedFormatException ex) {
                    logger.info((Object)"Unsupported format for Channel");
                    this.incrementProblems(ex);
                    return;
                }
                catch (IOException ioe) {
                    logger.info((Object)"Cannot retrieve Channel");
                    this.incrementProblems(ioe);
                    return;
                }
                catch (ChannelBuilderException e) {
                    e.printStackTrace();
                }
            }
            try {
                ChannelIF e = this.channel;
                synchronized (e) {
                    this.builder.beginTransaction();
                    ChannelIF tempChannel = FeedParser.parse(this.tempBuilder, this.channel.getLocation());
                    logger.info((Object)("Updating channel from " + this.channel.getLocation() + ": " + tempChannel + "(new)    " + this.channel + "(old)"));
                    InformaUtils.copyChannelProperties(tempChannel, this.channel);
                    this.builder.update(this.channel);
                    this.channel.setLastUpdated(new Date());
                    if (tempChannel.getItems().isEmpty()) {
                        logger.warn((Object)("No items found in channel " + this.channel));
                    } else {
                        for (ItemIF item : tempChannel.getItems()) {
                            if (this.channel.getItems().contains(item)) continue;
                            logger.debug((Object)("Found new item: " + item));
                            this.channel.addItem(this.builder.createItem(null, item));
                        }
                    }
                    this.builder.endTransaction();
                }
            }
            catch (ParseException pe) {
                this.incrementProblems(pe);
            }
            catch (IOException ioe) {
                this.incrementProblems(ioe);
            }
            catch (ChannelBuilderException e) {
                e.printStackTrace();
            }
        }
    }

    private void incrementProblems(Exception e) {
        this.info.increaseProblemsOccurred(e);
        if (this.info.shouldDeactivate()) {
            logger.warn((Object)("Deactivating channel after " + this.info.getNrProblemsOccurred() + " problems occurred."));
            this.registry.deactivateChannel(this.channel);
        }
        logger.warn((Object)e);
    }
}

