/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.utils.CacheSettingsIF;

public class RSS100Settings
implements CacheSettingsIF {
    private long defaultTtl = 3600000L;

    public void setDefaultTtl(long defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public long getTtl(ChannelIF channel, long ttlInMs) {
        long timeToExpire;
        ChannelUpdatePeriod updatePeriod = channel.getUpdatePeriod();
        int updateFrequency = channel.getUpdateFrequency();
        if (updatePeriod == null) {
            if (ttlInMs > 300000L) {
                return ttlInMs;
            }
            return this.defaultTtl;
        }
        if (updateFrequency < 0) {
            updateFrequency = 1;
        }
        if (ttlInMs > (timeToExpire = updatePeriod.getMsInPeriod() / (long)updateFrequency)) {
            return ttlInMs;
        }
        return timeToExpire;
    }
}

