/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.basic.Item;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.FormatDetector;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.PersistChanGrpMgr;
import de.nava.informa.utils.UpdateChannelInfo;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistChanGrpMgrTask
extends Thread {
    private static Log logger = LogFactory.getLog(PersistChanGrpMgrTask.class);
    private PersistChanGrpMgr mgr;
    private ChannelBuilder builder;
    private ChannelBuilderIF tempBuilder;
    private Map<URL, UpdateChannelInfo> channelInfos;
    private long minChannelUpdateDelay;
    private volatile boolean running = false;

    public PersistChanGrpMgrTask(PersistChanGrpMgr mgr, long minChannelUpdateDelay) {
        super("PCGrp: " + mgr.getChannelGroup().getTitle());
        this.minChannelUpdateDelay = minChannelUpdateDelay;
        this.mgr = mgr;
        this.builder = mgr.getBuilder();
        this.channelInfos = new HashMap<URL, UpdateChannelInfo>();
        this.tempBuilder = new de.nava.informa.impl.basic.ChannelBuilder();
    }

    public void setMinChannelUpdateDelay(long minChannelUpdateDelay) {
        this.minChannelUpdateDelay = minChannelUpdateDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        try {
            while (!this.isInterrupted()) {
                long startedLoop = System.currentTimeMillis();
                this.performUpdates();
                long leftToSleep = this.minChannelUpdateDelay - (startedLoop - System.currentTimeMillis());
                logger.debug((Object)("Going to sleep for " + leftToSleep + " millis"));
                if (leftToSleep <= 0L) continue;
                Thread.sleep(leftToSleep);
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted exception within Run method");
        }
        catch (Exception ignoredException) {
            ignoredException.printStackTrace();
        }
        finally {
            this.running = false;
            PersistChanGrpMgrTask e = this;
            synchronized (e) {
                this.notifyAll();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void interrupt() {
        this.interrupt(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(boolean wait) {
        super.interrupt();
        if (wait && this.isRunning()) {
            while (this.isRunning()) {
                try {
                    PersistChanGrpMgrTask persistChanGrpMgrTask = this;
                    synchronized (persistChanGrpMgrTask) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void performUpdates() {
        logger.debug((Object)("Starting channel updates loop for " + this.mgr.getChannelGroup().getTitle()));
        this.mgr.notifyPolling(true);
        Iterator iter = this.mgr.channelIterator();
        while (iter.hasNext()) {
            Channel nextChan = (Channel)iter.next();
            logger.info((Object)("processing: " + nextChan));
            try {
                this.handleChannel(nextChan, this.getUpdChanInfo(nextChan));
            }
            catch (RuntimeException e) {
                logger.error((Object)("Error during processing: " + nextChan), (Throwable)e);
            }
            catch (NoSuchMethodError ignoreNoSuchMethod) {
                logger.error((Object)("NoSuchMethodError exception within Run method. Ignoring." + nextChan), (Throwable)ignoreNoSuchMethod);
            }
        }
        this.mgr.notifyPolling(false);
        this.mgr.incrPollingCounter();
    }

    private UpdateChannelInfo getUpdChanInfo(Channel chan) {
        UpdateChannelInfo info = this.channelInfos.get(chan.getLocation());
        if (info == null) {
            info = new UpdateChannelInfo(this.mgr.getAcceptNrErrors());
            this.channelInfos.put(chan.getLocation(), info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChannel(Channel chan, UpdateChannelInfo info) {
        if (!info.shouldDeactivate()) {
            if (this.shouldUpdate(info)) {
                ChannelBuilder channelBuilder = this.builder;
                synchronized (channelBuilder) {
                    if (!info.getFormatDetected()) {
                        this.handleChannelHeader(chan, info);
                    }
                    this.handleChannelItems(chan, info);
                }
                info.setLastUpdatedTimestamp(System.currentTimeMillis());
            }
        } else {
            logger.info((Object)("Not processing channel: " + chan + " because exceeded error threshold."));
            return;
        }
    }

    private boolean shouldUpdate(UpdateChannelInfo info) {
        return System.currentTimeMillis() - info.getLastUpdatedTimestamp() > this.minChannelUpdateDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChannelHeader(Channel chan, UpdateChannelInfo info) {
        if (!info.getFormatDetected()) {
            logger.debug((Object)"Handling Channel Header. Format not yet detected.");
            try {
                this.builder.beginTransaction();
                this.builder.reload(chan);
                ChannelFormat format = FormatDetector.getFormat(chan.getLocation());
                chan.setFormat(format);
                info.setFormatDetected(true);
                chan.setLastUpdated(new Date());
                this.builder.endTransaction();
            }
            catch (UnknownHostException e) {
                logger.debug((Object)("Host not found: " + e.getMessage()));
            }
            catch (Exception e) {
                info.increaseProblemsOccurred(e);
                String msg = "Exception in handleChannelHeader for : " + chan;
                logger.fatal((Object)(msg + "\n     Continue...."));
            }
            finally {
                if (this.builder.inTransaction()) {
                    this.builder.resetTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChannelItems(Channel chan, UpdateChannelInfo info) {
        ChannelIF tempChannel = null;
        int logHowManySearched = 0;
        int logHowManyAdded = 0;
        try {
            this.builder.beginTransaction();
            this.builder.reload(chan);
            tempChannel = FeedParser.parse(this.tempBuilder, chan.getLocation());
            InformaUtils.copyChannelProperties(tempChannel, chan);
            chan.setLastUpdated(new Date());
            this.mgr.notifyChannelRetrieved(chan);
            if (!tempChannel.getItems().isEmpty()) {
                Iterator<ItemIF> it = tempChannel.getItems().iterator();
                while (it.hasNext()) {
                    ++logHowManySearched;
                    Item transientItem = (Item)it.next();
                    if (chan.getItems().contains(transientItem)) continue;
                    logger.info((Object)("Found new item: " + transientItem));
                    ++logHowManyAdded;
                    ItemIF newItem = this.builder.createItem(chan, transientItem);
                    this.mgr.notifyItemAdded((de.nava.informa.impl.hibernate.Item)newItem);
                }
            }
            this.builder.endTransaction();
        }
        catch (UnknownHostException e) {
            logger.debug((Object)("Host not found: " + e.getMessage()));
        }
        catch (Exception e) {
            info.increaseProblemsOccurred(e);
            String msg = "Exception in handleChannelItems. # Potential new items = " + logHowManySearched + ", # Items actually added to channel: " + logHowManyAdded + "\n     Stored Chan=" + chan + "\n     ParsedChan=" + tempChannel;
            logger.fatal((Object)(msg + "\n     Continue...."));
        }
        finally {
            if (this.builder.inTransaction()) {
                this.builder.resetTransaction();
            }
        }
    }
}

