/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.utils.Base64Decoder;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public final class ParserUtils {
    private static Log logger = LogFactory.getLog(ParserUtils.class);
    private static SimpleDateFormat[] dateFormats = null;
    private static SimpleDateFormat dfA;
    private static SimpleDateFormat dfB;
    private static SimpleDateFormat dfC;
    private static SimpleDateFormat dfD;

    private ParserUtils() {
    }

    public static URL getURL(String toURL) {
        URL result = null;
        try {
            if (toURL != null && toURL.trim().length() > 0) {
                result = new URL(toURL);
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Invalid URL " + toURL + " given."));
        }
        return result;
    }

    public static Namespace getDefaultNS(Element element) {
        return ParserUtils.getNamespace(element, "");
    }

    public static Namespace getNamespace(Element element, String prefix) {
        Namespace ns = prefix == null ? element.getNamespace("") : element.getNamespace(prefix);
        return ns;
    }

    public static Date getDate(String strdate) {
        Date result = null;
        if ((strdate = strdate.trim()).length() > 10) {
            String dateEnd;
            if ((strdate.substring(strdate.length() - 5).indexOf("+") == 0 || strdate.substring(strdate.length() - 5).indexOf("-") == 0) && strdate.substring(strdate.length() - 5).indexOf(":") == 2) {
                String sign = strdate.substring(strdate.length() - 5, strdate.length() - 4);
                strdate = strdate.substring(0, strdate.length() - 5) + sign + "0" + strdate.substring(strdate.length() - 4);
            }
            if (((dateEnd = strdate.substring(strdate.length() - 6)).indexOf("-") == 0 || dateEnd.indexOf("+") == 0) && dateEnd.indexOf(":") == 3) {
                if ("GMT".equals(strdate.substring(strdate.length() - 9, strdate.length() - 6))) {
                    logger.debug((Object)"General time zone with offset, no change ");
                } else {
                    String oldDate = strdate;
                    String newEnd = dateEnd.substring(0, 3) + dateEnd.substring(4);
                    strdate = oldDate.substring(0, oldDate.length() - 6) + newEnd;
                }
            }
        }
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                result = dateFormats[i].parse(strdate);
                break;
            }
            catch (ParseException eA) {
                logger.debug((Object)("parsing " + strdate + " [" + dateFormats[i].toPattern() + "] without success, trying again."));
                continue;
            }
        }
        return result;
    }

    public static Date getDateOLD(String strdate) {
        Date result = null;
        try {
            result = dfA.parse(strdate);
        }
        catch (ParseException eA) {
            logger.warn((Object)("Error parsing date (A): " + eA.getMessage()));
            try {
                result = dfB.parse(strdate);
            }
            catch (ParseException eB) {
                logger.warn((Object)("Error parsing date (B): " + eB.getMessage()));
                try {
                    result = dfC.parse(strdate);
                    result = ParserUtils.extractTimeZone(strdate, result);
                }
                catch (ParseException eC) {
                    logger.warn((Object)("Error parsing date (C): " + eC.getMessage()));
                    try {
                        result = dfD.parse(strdate);
                    }
                    catch (ParseException eD) {
                        logger.warn((Object)("Error parsing date (D): " + eD.getMessage()));
                        eD.printStackTrace();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing date '" + strdate + "' resulted in: " + result));
        }
        if (result == null) {
            logger.warn((Object)("No appropiate date could be extracted from " + strdate));
        }
        return result;
    }

    private static Date extractTimeZone(String strdate, Date thedate) {
        String tzSign = strdate.substring(strdate.length() - 6, strdate.length() - 5);
        String tzHour = strdate.substring(strdate.length() - 5, strdate.length() - 3);
        String tzMin = strdate.substring(strdate.length() - 2);
        if (tzSign.equals("-") || tzSign.equals("+")) {
            int h = Integer.parseInt(tzHour);
            int m = Integer.parseInt(tzMin);
            if (tzSign.equals("+")) {
                h = -1 * h;
                m = -1 * m;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(thedate);
            cal.add(11, h);
            cal.add(12, m);
            cal.add(14, ParserUtils.localTimeDiff(cal.getTimeZone(), thedate));
            thedate = cal.getTime();
        }
        return thedate;
    }

    private static int localTimeDiff(TimeZone tz, Date date) {
        if (tz.inDaylightTime(date)) {
            int dstSavings = 0;
            if (tz.useDaylightTime()) {
                dstSavings = 3600000;
            }
            return tz.getRawOffset() + dstSavings;
        }
        return tz.getRawOffset();
    }

    public static String formatDate(Date aDate) {
        return dfA.format(aDate);
    }

    public static String decodeBase64(String s) {
        return Base64Decoder.decode(s);
    }

    public static String unEscape(String value) {
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        return value;
    }

    public static String escape(String value) {
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&apos;");
        return value;
    }

    public static void matchCaseOfChildren(Element root, String[] childrenNames) {
        if (root == null || childrenNames.length == 0) {
            return;
        }
        int namesCount = childrenNames.length;
        HashMap<String, String> names = new HashMap<String, String>(namesCount);
        for (int i = 0; i < namesCount; ++i) {
            String lower;
            String childName = childrenNames[i];
            if (childName == null || names.containsKey(lower = childName.toLowerCase())) continue;
            names.put(lower, childName);
        }
        List elements = root.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            Element child = (Element)elements.get(i);
            String childName = child.getName().toLowerCase();
            if (!names.containsKey(childName)) continue;
            child.setName((String)names.get(childName));
        }
    }

    public static void matchCaseOfChildren(Element root, String childName) {
        if (root == null || childName == null) {
            return;
        }
        List elements = root.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            Element child = (Element)elements.get(i);
            String name = child.getName().toLowerCase();
            if (!name.equalsIgnoreCase(childName)) continue;
            child.setName(childName);
        }
    }

    static {
        String[] possibleDateFormats = new String[]{"EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm zzzz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSzzzz", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};
        dateFormats = new SimpleDateFormat[possibleDateFormats.length];
        TimeZone gmtTZ = TimeZone.getTimeZone("GMT");
        for (int i = 0; i < possibleDateFormats.length; ++i) {
            ParserUtils.dateFormats[i] = new SimpleDateFormat(possibleDateFormats[i], Locale.ENGLISH);
            dateFormats[i].setTimeZone(gmtTZ);
        }
        dfA = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dfB = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        dfC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dfD = new SimpleDateFormat("yyyy-MM-dd");
    }
}

