/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import java.net.HttpURLConnection;

public class HttpHeaderUtils {
    public static void setIfModifiedSince(HttpURLConnection conn, long value) {
        if (value > 0L) {
            conn.setIfModifiedSince(value);
        }
    }

    public static void setETagValue(HttpURLConnection conn, String etag) {
        if (etag != null) {
            conn.setRequestProperty("If-None-Match", etag);
        }
    }

    public static long getLastModified(HttpURLConnection conn) {
        long result = conn.getHeaderFieldDate("Last-Modified", 0L);
        return result;
    }

    public static String getETagValue(HttpURLConnection conn) {
        return conn.getHeaderField("ETag");
    }

    public static void setUserAgent(HttpURLConnection conn, String agent) {
        if (agent == null) {
            return;
        }
        conn.setRequestProperty("User-Agent", agent);
    }
}

