/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.UnsupportedFormatException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormatDetector {
    private static Log logger = LogFactory.getLog(FormatDetector.class);
    private static final int NR_FIRST_BYTES = 2048;

    public static ChannelFormat getFormat(URL url) throws IOException, UnsupportedFormatException {
        logger.info((Object)("Trying to retrieve stream from " + url));
        BufferedInputStream in = new BufferedInputStream(url.openStream(), 2048);
        return FormatDetector.getFormat(in);
    }

    public static ChannelFormat getFormat(InputStream in) throws IOException, UnsupportedFormatException {
        int bytes;
        byte[] b = new byte[2048];
        for (int bytesRead = 0; bytesRead < 2048 && (bytes = in.read(b, bytesRead, 2048 - bytesRead)) != -1; bytesRead += bytes) {
        }
        String rootElement = FormatDetector.getRootElement(b);
        logger.debug((Object)("Detected [" + rootElement + "]."));
        if (rootElement.startsWith("rss")) {
            if (rootElement.indexOf("0.91") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.91).");
                return ChannelFormat.RSS_0_91;
            }
            if (rootElement.indexOf("0.92") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.92).");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("0.93") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.93).");
                logger.warn((Object)"RSS 0.93 not fully supported yet, fall back to 0.92.");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("0.94") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.94).");
                logger.warn((Object)"RSS 0.94 not fully supported yet, fall back to 0.92.");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("2.0") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 2.0).");
                return ChannelFormat.RSS_2_0;
            }
            throw new UnsupportedFormatException("Unsupported RSS version [" + rootElement + "].");
        }
        if (rootElement.indexOf("rdf") >= 0) {
            logger.info((Object)"Channel uses RDF root element.");
            return ChannelFormat.RSS_1_0;
        }
        if (rootElement.indexOf("feed") >= 0) {
            if (rootElement.indexOf("0.1") >= 0) {
                return ChannelFormat.ATOM_0_1;
            }
            if (rootElement.indexOf("0.2") >= 0) {
                return ChannelFormat.ATOM_0_2;
            }
            if (rootElement.indexOf("0.3") >= 0) {
                return ChannelFormat.ATOM_0_3;
            }
            throw new UnsupportedFormatException("Unsupported ATOM version [" + rootElement + "].");
        }
        throw new UnsupportedFormatException("Not able to parse document with root element [" + rootElement + "].");
    }

    private static final String getRootElement(byte[] b) {
        String s = new String(b);
        int startPos = 0;
        int endPos = 0;
        boolean inComment = false;
        block0: for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '<' && Character.isLetter(s.charAt(i + 1)) && !inComment) {
                startPos = i + 1;
                for (int j = i + 1; j < s.length(); ++j) {
                    if (s.charAt(j) != '>') continue;
                    endPos = j;
                    break block0;
                }
                break;
            }
            if (!inComment && s.charAt(i) == '<' && s.charAt(i + 1) == '!' && s.charAt(i + 2) == '-' && s.charAt(i + 3) == '-') {
                inComment = true;
                continue;
            }
            if (!inComment || s.charAt(i) != '-' || s.charAt(i + 1) != '-' || s.charAt(i + 2) != '>') continue;
            inComment = false;
        }
        if (startPos >= 0 && endPos >= 0 && endPos > startPos) {
            return s.substring(startPos, endPos);
        }
        throw new IllegalArgumentException("Unable to retrieve root element from " + s);
    }
}

