/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.FeedIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.Feed;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.CacheSettings;
import de.nava.informa.utils.ConditionalGetValues;
import de.nava.informa.utils.FeedManagerException;
import de.nava.informa.utils.HttpHeaderUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedManagerEntry {
    public static final long MILLISECONDS_IN_HOUR = 3600000L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    public static final long MILLISECONDS_IN_MONTH = 2419200000L;
    public static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private static Log logger = LogFactory.getLog(FeedManagerEntry.class);
    private ChannelUpdatePeriod defaultUpdatePeriod;
    private int defaultUpdateFrequency;
    private long timeToExpire;
    private FeedIF feed;
    private long lastUpdate;
    private String feedUri;
    private ChannelBuilderIF channelBuilder;
    private long wantedTtl = -1L;
    private ConditionalGetValues httpHeaders = new ConditionalGetValues();

    public FeedManagerEntry(String feedUri, ChannelBuilderIF builder, ChannelUpdatePeriod defaultUpdatePeriod2, int defaultUpdateFrequency) throws FeedManagerException {
        this.feedUri = feedUri;
        this.channelBuilder = builder;
        this.defaultUpdatePeriod = defaultUpdatePeriod2;
        this.defaultUpdateFrequency = defaultUpdateFrequency;
        this.feed = this.retrieveFeed(feedUri);
        this.lastUpdate = System.currentTimeMillis();
    }

    public ChannelUpdatePeriod getDefaultUpdatePeriod() {
        return this.defaultUpdatePeriod;
    }

    public void setDefaultUpdatePeriod(ChannelUpdatePeriod defaultUpdatePeriod) {
        this.defaultUpdatePeriod = defaultUpdatePeriod;
    }

    public int getDefaultUpdateFrequency() {
        return this.defaultUpdateFrequency;
    }

    public void setDefaultUpdateFrequency(int defaultUpdateFrequency) {
        this.defaultUpdateFrequency = defaultUpdateFrequency;
    }

    private FeedIF retrieveFeed(String uri) throws FeedManagerException {
        try {
            URL urlToRetrieve = new URL(uri);
            URLConnection conn = null;
            try {
                conn = urlToRetrieve.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setInstanceFollowRedirects(true);
                    HttpHeaderUtils.setUserAgent(httpConn, "Informa Java API");
                    logger.debug((Object)("retr feed at url " + uri + ": ETag" + HttpHeaderUtils.getETagValue(httpConn) + " if-modified :" + HttpHeaderUtils.getLastModified(httpConn)));
                    this.httpHeaders.setETag(HttpHeaderUtils.getETagValue(httpConn));
                    this.httpHeaders.setIfModifiedSince(HttpHeaderUtils.getLastModified(httpConn));
                }
            }
            catch (ClassCastException e) {
                conn = null;
                logger.warn((Object)("problem cast to HttpURLConnection " + uri), (Throwable)e);
                throw new FeedManagerException(e);
            }
            catch (NullPointerException e) {
                logger.error((Object)("problem NPE " + uri + " conn=" + conn), (Throwable)e);
                conn = null;
                throw new FeedManagerException(e);
            }
            ChannelIF channel = null;
            channel = FeedParser.parse(this.getChannelBuilder(), conn.getInputStream());
            this.timeToExpire = this.getTimeToExpire(channel);
            this.feed = new Feed(channel);
            Date currDate = new Date();
            this.feed.setLastUpdated(currDate);
            this.feed.setDateFound(currDate);
            this.feed.setLocation(urlToRetrieve);
            logger.info((Object)("feed retrieved " + uri));
        }
        catch (IOException e) {
            logger.error((Object)("IOException " + this.feedUri + " e=" + e));
            e.printStackTrace();
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new FeedManagerException(e);
        }
        return this.feed;
    }

    private synchronized void updateChannel() throws FeedManagerException {
        try {
            String feedUrl = this.feed.getLocation().toString();
            URL aURL = null;
            try {
                aURL = new URL(feedUrl);
            }
            catch (MalformedURLException e) {
                logger.error((Object)("Could not create URL for " + feedUrl));
            }
            URLConnection conn = null;
            try {
                conn = aURL.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setInstanceFollowRedirects(true);
                    HttpHeaderUtils.setUserAgent(httpConn, "Informa Java API");
                    HttpHeaderUtils.setETagValue(httpConn, this.httpHeaders.getETag());
                    HttpHeaderUtils.setIfModifiedSince(httpConn, this.httpHeaders.getIfModifiedSince());
                    httpConn.connect();
                    if (httpConn.getResponseCode() == 304) {
                        logger.info((Object)("cond. GET for feed at url " + feedUrl + ": no change"));
                        this.feed.setLastUpdated(new Date());
                        this.lastUpdate = System.currentTimeMillis();
                        return;
                    }
                    logger.info((Object)("cond. GET for feed at url " + feedUrl + ": changed"));
                    logger.debug((Object)("feed at url " + feedUrl + " new values : ETag" + HttpHeaderUtils.getETagValue(httpConn) + " if-modified :" + HttpHeaderUtils.getLastModified(httpConn)));
                    this.httpHeaders.setETag(HttpHeaderUtils.getETagValue(httpConn));
                    this.httpHeaders.setIfModifiedSince(HttpHeaderUtils.getLastModified(httpConn));
                }
            }
            catch (ClassCastException e) {
                logger.warn((Object)("problem cast to HttpURLConnection (reading from a file?) " + feedUrl), (Throwable)e);
            }
            ChannelIF channel = null;
            channel = conn == null ? FeedParser.parse(this.getChannelBuilder(), feedUrl) : FeedParser.parse(this.getChannelBuilder(), conn.getInputStream());
            this.feed.setChannel(channel);
            this.feed.setLastUpdated(new Date());
            this.lastUpdate = System.currentTimeMillis();
            logger.info((Object)("feed updated " + feedUrl));
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
    }

    public FeedIF getFeed() throws FeedManagerException {
        if (this.isOutOfDate()) {
            this.updateChannel();
        }
        return this.feed;
    }

    public void setWantedTtl(long ms) {
        this.wantedTtl = ms;
        this.timeToExpire = this.getTimeToExpire(this.feed.getChannel());
    }

    private long getTimeToExpire(ChannelIF channel) {
        long temp = new CacheSettings().getTtl(channel, this.wantedTtl);
        return temp;
    }

    private boolean isOutOfDate() {
        boolean outOfDate = false;
        logger.info((Object)(this + " isOutOfDate " + this.feedUri + "lupdt: " + this.lastUpdate + ",tte=" + this.timeToExpire + "<?" + (System.currentTimeMillis() - this.lastUpdate)));
        if (this.lastUpdate + this.timeToExpire < System.currentTimeMillis()) {
            outOfDate = true;
        }
        return outOfDate;
    }

    private ChannelBuilderIF getChannelBuilder() {
        return this.channelBuilder;
    }
}

