/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.FeedIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.OPMLParser;
import de.nava.informa.utils.CacheSettings;
import de.nava.informa.utils.CacheSettingsIF;
import de.nava.informa.utils.FeedManagerEntry;
import de.nava.informa.utils.FeedManagerException;
import de.nava.informa.utils.FeedRefreshDaemon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedManager {
    private static final ChannelBuilderIF DEFAULT_BUILDER = new ChannelBuilder();
    private ChannelBuilderIF channelBuilder;
    private ChannelUpdatePeriod defaultUpdatePeriod;
    private int defaultUpdateFrequency;
    private Map<String, FeedManagerEntry> feeds;
    private CacheSettingsIF cacheSettings = new CacheSettings();
    private FeedRefreshDaemon refreshDaemon = new FeedRefreshDaemon();

    public FeedManager() {
        this.feeds = new HashMap<String, FeedManagerEntry>();
        this.defaultUpdatePeriod = ChannelUpdatePeriod.UPDATE_DAILY;
        this.defaultUpdateFrequency = 1;
        this.setCacheSettings(this.defaultUpdatePeriod, this.defaultUpdateFrequency);
    }

    public FeedManager(ChannelUpdatePeriod defaultUpdatePeriod, int defaultUpdateFrequency) {
        this.feeds = new HashMap<String, FeedManagerEntry>();
        this.defaultUpdatePeriod = defaultUpdatePeriod;
        this.defaultUpdateFrequency = defaultUpdateFrequency;
        this.setCacheSettings(defaultUpdatePeriod, defaultUpdateFrequency);
    }

    private void setCacheSettings(ChannelUpdatePeriod updatePeriod, int updateFrequency) {
        long MILLISECONDS_IN_HOUR = 3600000L;
        long MILLISECONDS_IN_DAY = 86400000L;
        long MILLISECONDS_IN_MONTH = 2419200000L;
        long MILLISECONDS_IN_YEAR = 31536000000L;
        long msInPeriod = 0L;
        if (updatePeriod.equals((Object)ChannelUpdatePeriod.UPDATE_HOURLY)) {
            msInPeriod = MILLISECONDS_IN_HOUR;
        } else if (updatePeriod.equals((Object)ChannelUpdatePeriod.UPDATE_DAILY)) {
            msInPeriod = MILLISECONDS_IN_DAY;
        } else if (updatePeriod.equals((Object)ChannelUpdatePeriod.UPDATE_MONTHLY)) {
            msInPeriod = MILLISECONDS_IN_MONTH;
        } else if (updatePeriod.equals((Object)ChannelUpdatePeriod.UPDATE_YEARLY)) {
            msInPeriod = MILLISECONDS_IN_YEAR;
        } else {
            throw new IllegalArgumentException("updatePeriod " + (Object)((Object)updatePeriod) + " is not valid");
        }
        this.cacheSettings.setDefaultTtl(msInPeriod / (long)updateFrequency);
    }

    public FeedIF addFeed(FeedIF feed) throws FeedManagerException {
        return this.addFeed(feed.getLocation().toString());
    }

    public FeedIF addFeed(FeedIF feed, int ttl) throws FeedManagerException {
        return this.addFeed(feed.getLocation().toString(), ttl);
    }

    public Collection<FeedIF> addFeeds(String opmlFeedUri) throws FeedManagerException {
        ArrayList<FeedIF> retFeeds = null;
        try {
            Collection feedsColl = OPMLParser.parse(opmlFeedUri);
            retFeeds = new ArrayList<FeedIF>();
            for (FeedIF element : feedsColl) {
                retFeeds.add(this.addFeed(element));
            }
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
        return retFeeds;
    }

    public Collection<FeedIF> addFeeds(String opmlFeedUri, int ttl) throws FeedManagerException {
        ArrayList<FeedIF> retFeeds = null;
        try {
            Collection feedsColl = OPMLParser.parse(opmlFeedUri);
            retFeeds = new ArrayList<FeedIF>();
            for (FeedIF element : feedsColl) {
                retFeeds.add(this.addFeed(element, ttl));
            }
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
        return retFeeds;
    }

    public void setChannelBuilder(ChannelBuilderIF chBuilder) {
        this.channelBuilder = chBuilder;
    }

    public ChannelBuilderIF getChannelBuilder() {
        if (this.channelBuilder == null) {
            return DEFAULT_BUILDER;
        }
        return this.channelBuilder;
    }

    public boolean hasFeed(String feedUri) {
        return this.feeds.containsKey(feedUri);
    }

    public FeedIF addFeed(String feedUri) throws FeedManagerException {
        if (!this.hasFeed(feedUri)) {
            FeedManagerEntry fme = new FeedManagerEntry(feedUri, this.getChannelBuilder(), this.defaultUpdatePeriod, this.defaultUpdateFrequency);
            this.feeds.put(feedUri, fme);
            this.refreshDaemon.addFeed(fme);
        }
        return this.getFeed(feedUri);
    }

    public FeedIF addFeed(String feedUri, int wantedTtlmins) throws FeedManagerException {
        if (!this.hasFeed(feedUri)) {
            FeedManagerEntry FMEntry = new FeedManagerEntry(feedUri, this.getChannelBuilder(), this.defaultUpdatePeriod, this.defaultUpdateFrequency);
            if (wantedTtlmins > 0) {
                FMEntry.setWantedTtl(wantedTtlmins * 60000);
            }
            this.feeds.put(feedUri, FMEntry);
            this.refreshDaemon.addFeed(FMEntry);
        }
        return this.getFeed(feedUri);
    }

    public void removeFeed(String feedUri) {
        this.feeds.remove(feedUri);
    }

    public FeedIF getFeed(String feedUri) throws FeedManagerException {
        FeedIF feed = null;
        if (this.hasFeed(feedUri)) {
            FeedManagerEntry entry = this.feeds.get(feedUri);
            feed = entry.getFeed();
        }
        return feed;
    }
}

