/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.utils.ParserUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.CDATA;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

public class AtomParserUtils {
    private static final String[] ITEM_LINK_REL_PREFERRENCE_ORDER = new String[]{"alternate", null};
    private static final String[] ITEM_LINK_TYPES_PREFERRENCE_ORDER = new String[]{"text/html", "text/plain"};
    public static final Log LOGGER = LogFactory.getLog(AtomParserUtils.class);
    private static final XMLOutputter OUTPUTER = new XMLOutputter();

    private static void clearNamespace(Element elt) {
        if (elt == null) {
            return;
        }
        elt.setNamespace(null);
        List content = elt.getContent();
        for (int i = 0; i < content.size(); ++i) {
            Object item = content.get(i);
            if (!(item instanceof Element)) continue;
            AtomParserUtils.clearNamespace((Element)item);
        }
    }

    public static String getItemLink(Element item, Namespace defNS) {
        String currentHref = null;
        int currentOrder = Integer.MAX_VALUE;
        List links = item.getChildren("link", defNS);
        for (int i = 0; currentOrder != 0 && i < links.size(); ++i) {
            String href;
            Element link = (Element)links.get(i);
            String type = link.getAttributeValue("type");
            String rel = link.getAttributeValue("rel");
            if (type != null) {
                type = type.trim().toLowerCase();
            }
            int preferenceOrder = AtomParserUtils.getPreferenceOrderForItemLinkType(type, rel);
            System.out.println("Link " + link.getAttributeValue("href") + " with pref " + AtomParserUtils.getPreferenceOrderForItemLinkType(type, rel) + " " + type + " " + rel);
            if (preferenceOrder >= currentOrder || (href = link.getAttributeValue("href")) == null) continue;
            currentHref = href.trim();
            currentOrder = preferenceOrder;
        }
        LOGGER.debug((Object)("url read : " + currentHref));
        return currentHref;
    }

    public static int getPreferenceOrderForItemLinkType(String type, String rel) {
        int orderType = -1;
        if (type != null) {
            for (int i = 0; orderType == -1 && i < ITEM_LINK_TYPES_PREFERRENCE_ORDER.length; ++i) {
                if (!type.equals(ITEM_LINK_TYPES_PREFERRENCE_ORDER[i])) continue;
                orderType = i;
            }
        }
        if (orderType == -1) {
            orderType = ITEM_LINK_TYPES_PREFERRENCE_ORDER.length;
        }
        int orderRel = -1;
        if (rel != null) {
            for (int i = 0; orderRel == -1 && i < ITEM_LINK_REL_PREFERRENCE_ORDER.length; ++i) {
                if (!rel.equals(ITEM_LINK_REL_PREFERRENCE_ORDER[i])) continue;
                orderRel = i;
            }
        }
        if (orderRel == -1) {
            orderRel = ITEM_LINK_REL_PREFERRENCE_ORDER.length;
        }
        return orderRel * (ITEM_LINK_REL_PREFERRENCE_ORDER.length + 1) + orderType;
    }

    public static String getValue(Element elt, String mode) {
        if (elt == null) {
            return "";
        }
        mode = mode == null ? "xml" : mode;
        AtomParserUtils.clearNamespace(elt);
        List content = elt.getContent();
        content = AtomParserUtils.trimContents(content);
        String value = content.size() == 1 && content.get(0) instanceof CDATA ? ((CDATA)content.get(0)).getValue() : OUTPUTER.outputString(content);
        if ("escaped".equals(mode)) {
            value = ParserUtils.unEscape(value);
        } else if ("base64".equals(mode)) {
            value = ParserUtils.decodeBase64(value);
        }
        return value;
    }

    public static List trimContents(List contents) {
        int tail;
        int head;
        if (contents == null) {
            return contents;
        }
        int count = contents.size();
        for (head = 0; head < count && contents.get(head) instanceof Text && ((Text)contents.get(head)).getTextTrim().length() == 0; ++head) {
        }
        for (tail = count - 1; tail > head && contents.get(tail) instanceof Text && ((Text)contents.get(tail)).getTextTrim().length() == 0; --tail) {
        }
        return tail >= head ? contents.subList(head, tail + 1) : new ArrayList();
    }
}

