/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.search;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.search.ItemDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelIndexer {
    private static Log logger = LogFactory.getLog(ChannelIndexer.class);
    private String indexDir;
    private int nrOfIndexedItems;
    private Analyzer analyzer;

    public ChannelIndexer(String indexDir) {
        this.indexDir = indexDir;
        this.nrOfIndexedItems = 0;
        this.analyzer = new StandardAnalyzer();
    }

    public void indexChannels(boolean createNewIndex, Collection channels) throws IOException {
        ArrayList<ItemIF> items = new ArrayList<ItemIF>();
        for (ChannelIF channel : channels) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Searching channel " + channel + " for items."));
            }
            items.addAll(channel.getItems());
        }
        if (!items.isEmpty()) {
            this.indexItems(createNewIndex, items);
        } else {
            logger.info((Object)"No items found for indexing.");
        }
    }

    public void indexItems(boolean createNewIndex, Collection<ItemIF> items) throws IOException {
        logger.info((Object)"Start writing index.");
        IndexWriter writer = new IndexWriter(this.indexDir, this.analyzer, createNewIndex);
        for (ItemIF item : items) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add item " + item + " to index."));
            }
            writer.addDocument(ItemDocument.makeDocument(item));
        }
        writer.optimize();
        this.nrOfIndexedItems = writer.docCount();
        writer.close();
        logger.info((Object)"Finished writing index.");
    }

    public int getNrOfIndexedItems() {
        return this.nrOfIndexedItems;
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public String getIndexDir() {
        return this.indexDir;
    }
}

