/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelParserIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

class RSS_2_0_Parser
implements ChannelParserIF {
    private static Log logger = LogFactory.getLog(RSS_2_0_Parser.class);

    private RSS_2_0_Parser() {
    }

    public static RSS_2_0_Parser getInstance() {
        return RSS_2_0_ParserHolder.instance;
    }

    private CategoryIF getCategoryList(CategoryIF parent, String title, Hashtable children) {
        ChannelBuilder builder = new ChannelBuilder();
        CategoryIF cat = builder.createCategory(parent, title);
        Enumeration itChild = children.keys();
        while (itChild.hasMoreElements()) {
            String childKey = (String)itChild.nextElement();
            this.getCategoryList(cat, childKey, (Hashtable)children.get(childKey));
        }
        return cat;
    }

    public ChannelIF parse(ChannelBuilderIF cBuilder, Element root) throws ParseException {
        Element cloud;
        Element webMaster;
        Element managingEditor;
        Element lastBuildDate;
        Element pubDate;
        Element ttl;
        Element generator;
        Element docs;
        Element rating;
        Element copyright;
        Element txtinp;
        String key;
        Enumeration enumCategories;
        ArrayList<CategoryIF> catList;
        String[] titles;
        Element elCategory;
        RecursiveHashtable currTable;
        Iterator itCat;
        RecursiveHashtable catTable;
        List listCategory;
        Namespace dcNS;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        logger.debug((Object)"start parsing.");
        Namespace defNS = ParserUtils.getDefaultNS(root);
        if (defNS == null) {
            defNS = Namespace.NO_NAMESPACE;
            logger.info((Object)"No default namespace found.");
        }
        if ((dcNS = ParserUtils.getNamespace(root, "dc")) == null) {
            dcNS = defNS;
        }
        Namespace contentNS = ParserUtils.getNamespace(root, "content");
        ParserUtils.matchCaseOfChildren(root, "channel");
        Element channel = root.getChild("channel", defNS);
        if (channel == null) {
            logger.warn((Object)"Channel element could not be retrieved from feed.");
            throw new ParseException("No channel element found in feed.");
        }
        ParserUtils.matchCaseOfChildren(channel, new String[]{"title", "description", "link", "language", "item", "image", "textinput", "copyright", "rating", "docs", "generator", "pubDate", "lastBuildDate", "category", "managingEditor", "webMaster", "cloud"});
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title", defNS));
        chnl.setFormat(ChannelFormat.RSS_2_0);
        chnl.setDescription(channel.getChildTextTrim("description", defNS));
        chnl.setSite(ParserUtils.getURL(channel.getChildTextTrim("link", defNS)));
        chnl.setLanguage(channel.getChildTextTrim("language", defNS));
        List items = channel.getChildren("item", defNS);
        for (Element item : items) {
            Attribute lengthAttribute;
            Attribute typeAttribute;
            Element elEnclosure;
            Element elSource;
            String guidUrl;
            Element elDate;
            Element elDesc;
            ParserUtils.matchCaseOfChildren(item, new String[]{"title", "link", "encoded", "description", "subject", "category", "pubDate", "date", "author", "creator", "comments", "guid", "source", "enclosure"});
            Element elTitle = item.getChild("title", defNS);
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = elTitle.getTextTrim();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Item element found (" + strTitle + ")."));
            }
            Element elLink = item.getChild("link", defNS);
            String strLink = "";
            if (elLink != null) {
                strLink = elLink.getTextTrim();
            }
            if ((elDesc = item.getChild("encoded", contentNS)) == null) {
                elDesc = item.getChild("description", defNS);
            }
            String strDesc = "";
            if (elDesc != null) {
                strDesc = elDesc.getTextTrim();
            }
            ItemIF rssItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            Element elSubject = item.getChild("subject", defNS);
            if (elSubject == null) {
                elSubject = item.getChild("subject", dcNS);
            }
            if (elSubject != null) {
                rssItem.setSubject(elSubject.getTextTrim());
            }
            if ((listCategory = item.getChildren("category", defNS)).size() < 1) {
                listCategory = item.getChildren("category", dcNS);
            }
            if (listCategory.size() > 0) {
                catTable = new RecursiveHashtable();
                itCat = listCategory.iterator();
                while (itCat.hasNext()) {
                    currTable = catTable;
                    elCategory = (Element)itCat.next();
                    titles = elCategory.getTextNormalize().split("/");
                    for (int x = 0; x < titles.length; ++x) {
                        if (!currTable.containsKey(titles[x])) {
                            currTable.put(titles[x], new RecursiveHashtable());
                        }
                        currTable = (RecursiveHashtable)currTable.get(titles[x]);
                    }
                }
                catList = new ArrayList();
                enumCategories = catTable.keys();
                while (enumCategories.hasMoreElements()) {
                    key = (String)enumCategories.nextElement();
                    CategoryIF cat = this.getCategoryList(null, key, (Hashtable)catTable.get(key));
                    catList.add(cat);
                }
                if (catList.size() > 0) {
                    rssItem.setCategories(catList);
                }
            }
            if ((elDate = item.getChild("pubDate", defNS)) == null) {
                elDate = item.getChild("date", dcNS);
            }
            if (elDate != null) {
                rssItem.setDate(ParserUtils.getDate(elDate.getTextTrim()));
            }
            rssItem.setFound(dateParsed);
            Element elAuthor = item.getChild("author", defNS);
            if (elAuthor == null) {
                elAuthor = item.getChild("creator", dcNS);
            }
            if (elAuthor != null) {
                rssItem.setCreator(elAuthor.getTextTrim());
            }
            Element elComments = item.getChild("comments", defNS);
            String strComments = "";
            if (elComments != null) {
                strComments = elComments.getTextTrim();
            }
            rssItem.setComments(ParserUtils.getURL(strComments));
            Element elGuid = item.getChild("guid", defNS);
            if (elGuid != null && (guidUrl = elGuid.getTextTrim()) != null) {
                String permaLinkStr;
                boolean permaLink = true;
                Attribute permaLinkAttribute = elGuid.getAttribute("isPermaLink", defNS);
                if (permaLinkAttribute != null && (permaLinkStr = permaLinkAttribute.getValue()) != null) {
                    permaLink = Boolean.valueOf(permaLinkStr);
                }
                ItemGuidIF itemGuid = cBuilder.createItemGuid(rssItem, guidUrl, permaLink);
                rssItem.setGuid(itemGuid);
            }
            if ((elSource = item.getChild("source", defNS)) != null) {
                String sourceName = elSource.getTextTrim();
                Attribute sourceAttribute = elSource.getAttribute("url", defNS);
                if (sourceAttribute != null) {
                    String sourceLocation = sourceAttribute.getValue().trim();
                    ItemSourceIF itemSource = cBuilder.createItemSource(rssItem, sourceName, sourceLocation, null);
                    rssItem.setSource(itemSource);
                }
            }
            if ((elEnclosure = item.getChild("enclosure", defNS)) == null) continue;
            URL location = null;
            String type = null;
            int length = -1;
            Attribute urlAttribute = elEnclosure.getAttribute("url", defNS);
            if (urlAttribute != null) {
                location = ParserUtils.getURL(urlAttribute.getValue().trim());
            }
            if ((typeAttribute = elEnclosure.getAttribute("type", defNS)) != null) {
                type = typeAttribute.getValue().trim();
            }
            if ((lengthAttribute = elEnclosure.getAttribute("length", defNS)) != null) {
                try {
                    length = Integer.parseInt(lengthAttribute.getValue().trim());
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            ItemEnclosureIF itemEnclosure = cBuilder.createItemEnclosure(rssItem, location, type, length);
            rssItem.setEnclosure(itemEnclosure);
        }
        Element image = channel.getChild("image", defNS);
        if (image != null) {
            Element imgDescr;
            Element imgHeight;
            ParserUtils.matchCaseOfChildren(image, new String[]{"title", "url", "link", "width", "height", "description"});
            ImageIF rssImage = cBuilder.createImage(image.getChildTextTrim("title", defNS), ParserUtils.getURL(image.getChildTextTrim("url", defNS)), ParserUtils.getURL(image.getChildTextTrim("link", defNS)));
            Element imgWidth = image.getChild("width", defNS);
            if (imgWidth != null) {
                try {
                    rssImage.setWidth(Integer.parseInt(imgWidth.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Error parsing width: " + e.getMessage()));
                }
            }
            if ((imgHeight = image.getChild("height", defNS)) != null) {
                try {
                    rssImage.setHeight(Integer.parseInt(imgHeight.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Error parsing height: " + e.getMessage()));
                }
            }
            if ((imgDescr = image.getChild("description", defNS)) != null) {
                rssImage.setDescription(imgDescr.getTextTrim());
            }
            chnl.setImage(rssImage);
        }
        if ((txtinp = channel.getChild("textinput", defNS)) != null) {
            ParserUtils.matchCaseOfChildren(txtinp, new String[]{"title", "description", "name", "link"});
            TextInputIF rssTextInput = cBuilder.createTextInput(txtinp.getChildTextTrim("title", defNS), txtinp.getChildTextTrim("description", defNS), txtinp.getChildTextTrim("name", defNS), ParserUtils.getURL(txtinp.getChildTextTrim("link", defNS)));
            chnl.setTextInput(rssTextInput);
        }
        if ((copyright = channel.getChild("copyright", defNS)) != null) {
            chnl.setCopyright(copyright.getTextTrim());
        }
        if ((rating = channel.getChild("rating", defNS)) != null) {
            chnl.setRating(rating.getTextTrim());
        }
        if ((docs = channel.getChild("docs", defNS)) != null) {
            chnl.setDocs(docs.getTextTrim());
        }
        if ((generator = channel.getChild("generator", defNS)) != null) {
            chnl.setGenerator(generator.getTextTrim());
        }
        if ((ttl = channel.getChild("ttl", defNS)) != null) {
            String ttlValue = ttl.getTextTrim();
            try {
                chnl.setTtl(Integer.parseInt(ttlValue));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Invalid TTL format: '" + ttlValue + "'"));
            }
        }
        if ((pubDate = channel.getChild("pubDate", defNS)) != null) {
            chnl.setPubDate(ParserUtils.getDate(pubDate.getTextTrim()));
        }
        if ((lastBuildDate = channel.getChild("lastBuildDate", defNS)) != null) {
            chnl.setLastBuildDate(ParserUtils.getDate(lastBuildDate.getTextTrim()));
        }
        if ((listCategory = channel.getChildren("category", defNS)).size() < 1) {
            listCategory = channel.getChildren("category", dcNS);
        }
        if (listCategory.size() > 0) {
            catTable = new RecursiveHashtable();
            itCat = listCategory.iterator();
            while (itCat.hasNext()) {
                currTable = catTable;
                elCategory = (Element)itCat.next();
                titles = elCategory.getTextNormalize().split("/");
                for (int x = 0; x < titles.length; ++x) {
                    if (!currTable.containsKey(titles[x])) {
                        currTable.put(titles[x], new RecursiveHashtable());
                    }
                    currTable = (RecursiveHashtable)currTable.get(titles[x]);
                }
            }
            catList = new ArrayList<CategoryIF>();
            enumCategories = catTable.keys();
            while (enumCategories.hasMoreElements()) {
                key = (String)enumCategories.nextElement();
                CategoryIF cat = this.getCategoryList(null, key, (Hashtable)catTable.get(key));
                catList.add(cat);
            }
            if (catList.size() > 0) {
                chnl.setCategories(catList);
            }
        }
        if ((managingEditor = channel.getChild("managingEditor", defNS)) != null) {
            chnl.setCreator(managingEditor.getTextTrim());
        }
        if ((webMaster = channel.getChild("webMaster", defNS)) != null) {
            chnl.setPublisher(webMaster.getTextTrim());
        }
        if ((cloud = channel.getChild("cloud", defNS)) != null) {
            String _port = cloud.getAttributeValue("port", defNS);
            int port = -1;
            if (_port != null) {
                try {
                    port = Integer.parseInt(_port);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            chnl.setCloud(cBuilder.createCloud(cloud.getAttributeValue("domain", defNS), port, cloud.getAttributeValue("path", defNS), cloud.getAttributeValue("registerProcedure", defNS), cloud.getAttributeValue("protocol", defNS)));
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecursiveHashtable<T>
    extends Hashtable<T, RecursiveHashtable<T>> {
        private static final long serialVersionUID = -3748524793347081535L;

        private RecursiveHashtable() {
        }

        @Override
        public synchronized RecursiveHashtable<T> put(T key, RecursiveHashtable<T> value) {
            return super.put(key, value);
        }
    }

    private static class RSS_2_0_ParserHolder {
        private static RSS_2_0_Parser instance = new RSS_2_0_Parser();

        private RSS_2_0_ParserHolder() {
        }
    }
}

