/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.FeedIF;
import de.nava.informa.impl.basic.Feed;
import de.nava.informa.utils.ParserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OPML_1_1_Parser {
    private static Log logger = LogFactory.getLog(OPML_1_1_Parser.class);

    OPML_1_1_Parser() {
    }

    static Collection<FeedIF> parse(Element root) {
        ArrayList<FeedIF> feedColl = new ArrayList<FeedIF>();
        Date dateParsed = new Date();
        logger.debug((Object)"start parsing.");
        ParserUtils.matchCaseOfChildren(root, "body");
        Element bodyElem = root.getChild("body");
        ParserUtils.matchCaseOfChildren(bodyElem, "outline");
        List feeds = bodyElem.getChildren("outline");
        for (Element feedElem : feeds) {
            Attribute attrHtmlUrl;
            Attribute attrTitle = feedElem.getAttribute("title");
            String strTitle = "[No Title]";
            if (attrTitle != null) {
                strTitle = attrTitle.getValue();
            }
            Feed feed = new Feed(strTitle);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Feed element found (" + strTitle + ")."));
            }
            Attribute attrText = feedElem.getAttribute("text");
            String strText = "[No Text]";
            if (attrText != null) {
                strText = attrText.getValue();
            }
            feed.setText(strText);
            Attribute attrType = feedElem.getAttribute("type");
            String strType = "text/xml";
            if (attrType != null) {
                strType = attrType.getValue();
            }
            feed.setContentType(strType);
            Attribute attrXmlUrl = feedElem.getAttribute("xmlUrl");
            if (attrXmlUrl != null && attrXmlUrl.getValue() != null) {
                feed.setLocation(ParserUtils.getURL(attrXmlUrl.getValue()));
            }
            if ((attrHtmlUrl = feedElem.getAttribute("htmlUrl")) != null && attrHtmlUrl.getValue() != null) {
                feed.setSite(ParserUtils.getURL(attrHtmlUrl.getValue()));
            }
            feed.setDateFound(dateParsed);
            feedColl.add(feed);
        }
        return feedColl;
    }
}

