/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.FeedIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.parsers.OPML_1_1_Parser;
import de.nava.informa.utils.NoOpEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPMLParser {
    private static Log logger = LogFactory.getLog(OPMLParser.class);

    private OPMLParser() {
    }

    public static Collection parse(URL aURL) throws IOException, ParseException {
        return OPMLParser.parse(new InputSource(aURL.toExternalForm()), aURL);
    }

    public static Collection parse(String url) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = new URL(url);
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Could not create URL for " + url));
        }
        return OPMLParser.parse(new InputSource(url), aURL);
    }

    public static Collection parse(Reader reader) throws IOException, ParseException {
        return OPMLParser.parse(new InputSource(reader), null);
    }

    public static Collection parse(InputStream stream) throws IOException, ParseException {
        return OPMLParser.parse(new InputSource(stream), null);
    }

    public static Collection<FeedIF> parse(File aFile) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = aFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("File " + aFile + " had invalid URL " + "representation.");
        }
        return OPMLParser.parse(new InputSource(aURL.toExternalForm()), aURL);
    }

    public static Collection<FeedIF> parse(InputSource inpSource, URL baseLocation) throws IOException, ParseException {
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        try {
            Document doc = saxBuilder.build(inpSource);
            return OPMLParser.parse(doc);
        }
        catch (JDOMException e) {
            throw new ParseException(e);
        }
    }

    private static synchronized Collection<FeedIF> parse(Document doc) throws ParseException {
        String opmlVersion;
        logger.debug((Object)"start parsing.");
        Element root = doc.getRootElement();
        String rootElement = root.getName().toLowerCase();
        if (rootElement.startsWith("opml") && (opmlVersion = root.getAttribute("version").getValue()).indexOf("1.1") >= 0) {
            logger.info((Object)"Collection uses OPML root element (Version 1.1).");
            return OPML_1_1_Parser.parse(root);
        }
        throw new UnsupportedFormatException("Unsupported OPML root element [" + rootElement + "].");
    }
}

