/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.Atom_0_3_Parser;
import de.nava.informa.parsers.Atom_1_0_Parser;
import de.nava.informa.parsers.RSS_0_91_Parser;
import de.nava.informa.parsers.RSS_1_0_Parser;
import de.nava.informa.parsers.RSS_2_0_Parser;
import de.nava.informa.utils.NoOpEntityResolver;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class FeedParser {
    private static final Log LOGGER = LogFactory.getLog(FeedParser.class);
    private static String saxDriverClassName = null;

    public static synchronized void setSaxDriverClassName(String className) throws ClassNotFoundException {
        Class<?> saxDriverClass = Class.forName(className);
        Class<?>[] extendsImplements = saxDriverClass.getInterfaces();
        boolean found = false;
        for (int i = 0; !found && i < extendsImplements.length; ++i) {
            Class<?> parent = extendsImplements[i];
            found = parent == XMLReader.class;
        }
        if (!found) {
            throw new ClassCastException("Specified class " + className + " does not implement XMLReader.");
        }
        saxDriverClassName = className;
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, String url) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.warn((Object)("Could not create URL for " + url));
        }
        return FeedParser.parse(cBuilder, new InputSource(url), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, URL aURL) throws IOException, ParseException {
        return FeedParser.parse(cBuilder, new InputSource(aURL.toExternalForm()), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, Reader reader) throws IOException, ParseException {
        return FeedParser.parse(cBuilder, new InputSource(reader), null);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, InputStream stream) throws IOException, ParseException {
        return FeedParser.parse(cBuilder, new InputSource(stream), null);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, File aFile) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = aFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("File " + aFile + " had invalid URL representation.");
        }
        return FeedParser.parse(cBuilder, new InputSource(aURL.toExternalForm()), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, InputSource inpSource, URL baseLocation) throws IOException, ParseException {
        SAXBuilder saxBuilder = new SAXBuilder(saxDriverClassName);
        saxBuilder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        try {
            Document doc = saxBuilder.build(inpSource);
            ChannelIF channel = FeedParser.parse(cBuilder, doc);
            channel.setLocation(baseLocation);
            return channel;
        }
        catch (JDOMException e) {
            throw new ParseException("Problem parsing " + inpSource.getSystemId() + ": " + (Object)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized ChannelIF parse(ChannelBuilderIF cBuilder, Document doc) throws ParseException {
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        LOGGER.debug((Object)"start parsing.");
        Element root = doc.getRootElement();
        String rootElement = root.getName().toLowerCase();
        if (rootElement.startsWith("rss")) {
            String rssVersion = root.getAttribute("version").getValue();
            if (rssVersion.indexOf("0.91") >= 0) {
                LOGGER.info((Object)"Channel uses RSS root element (Version 0.91).");
                return RSS_0_91_Parser.getInstance().parse(cBuilder, root);
            }
            if (rssVersion.indexOf("0.92") >= 0) {
                LOGGER.info((Object)"Channel uses RSS root element (Version 0.92).");
                return RSS_0_91_Parser.getInstance().parse(cBuilder, root);
            }
            if (rootElement.indexOf("0.93") >= 0) {
                LOGGER.info((Object)"Channel uses RSS root element (Version 0.93).");
                LOGGER.warn((Object)"RSS 0.93 not fully supported yet, fall back to 0.91.");
                throw new UnsupportedFormatException("Unsupported root element [" + rootElement + "].");
            }
            if (rootElement.indexOf("0.94") >= 0) {
                LOGGER.info((Object)"Channel uses RSS root element (Version 0.94).");
                LOGGER.warn((Object)"RSS 0.94 not fully supported yet, will use RSS 2.0");
                return RSS_2_0_Parser.getInstance().parse(cBuilder, root);
            }
            if (rssVersion.indexOf("2.0") < 0) {
                if (!rssVersion.equals("2")) throw new UnsupportedFormatException("Unsupported RSS version [" + rssVersion + "].");
            }
            LOGGER.info((Object)"Channel uses RSS root element (Version 2.0).");
            return RSS_2_0_Parser.getInstance().parse(cBuilder, root);
        }
        if (rootElement.indexOf("rdf") >= 0) {
            return RSS_1_0_Parser.getInstance().parse(cBuilder, root);
        }
        if (rootElement.indexOf("feed") < 0) throw new UnsupportedFormatException("Unsupported root element [" + rootElement + "].");
        Attribute versionAttr = root.getAttribute("version");
        Namespace namespace = ParserUtils.getDefaultNS(root);
        if (versionAttr != null) {
            String feedVersion = versionAttr.getValue();
            if (feedVersion.indexOf("0.1") < 0 && feedVersion.indexOf("0.2") < 0) {
                if (feedVersion.indexOf("0.3") < 0) throw new UnsupportedFormatException("Unsupported root element [" + rootElement + "].");
                LOGGER.info((Object)"Channel uses feed root element (Version 0.3).");
                return Atom_0_3_Parser.getInstance().parse(cBuilder, root);
            }
            LOGGER.info((Object)("Channel uses feed root element (Version " + feedVersion + ")."));
            LOGGER.warn((Object)"This atom version is not really supported yet, assume Atom 0.3 format");
            return Atom_0_3_Parser.getInstance().parse(cBuilder, root);
        }
        if (namespace == null) throw new UnsupportedFormatException("Unsupported root element [" + rootElement + "].");
        if (namespace.getURI() == null) throw new UnsupportedFormatException("Unsupported root element [" + rootElement + "].");
        if (!namespace.getURI().equals("http://www.w3.org/2005/Atom")) {
            LOGGER.warn((Object)"Channel uses unknown namespace in feed root element, assume Atom 1.0 format.");
            return Atom_1_0_Parser.getInstance().parse(cBuilder, root);
        }
        LOGGER.info((Object)"Channel uses feed root element (Atom 1.0 format).");
        return Atom_1_0_Parser.getInstance().parse(cBuilder, root);
    }

    public static void main(String[] args) throws IOException, ParseException {
        if (args.length < 2) {
            System.err.println("Usage: java " + FeedParser.class.getName() + " [-f <filename> | -u <url>]");
            System.exit(1);
        }
        String option = args[0];
        String data = args[1];
        ChannelIF channel = null;
        ChannelBuilder builder = new ChannelBuilder();
        channel = option.trim().startsWith("-f") ? FeedParser.parse((ChannelBuilderIF)builder, new File(data)) : FeedParser.parse((ChannelBuilderIF)builder, new URL(data));
        System.out.println("Channel format: " + channel.getFormat().toString());
        System.out.println(channel);
        System.out.println("containing " + channel.getItems().size() + " items");
        for (ItemIF item : channel.getItems()) {
            System.out.println("  - " + item);
        }
    }
}

