/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelParserIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.utils.AtomParserUtils;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class Atom_1_0_Parser
implements ChannelParserIF {
    private static final Log LOGGER = LogFactory.getLog(Atom_1_0_Parser.class);

    private Atom_1_0_Parser() {
    }

    public static Atom_1_0_Parser getInstance() {
        return Atom_1_0_ParserHolder.instance;
    }

    static String getAuthorString(List authors, Namespace defNS) {
        String author = "";
        for (Element authorElt : authors) {
            if (authorElt == null) continue;
            ParserUtils.matchCaseOfChildren(authorElt, "name");
            if (!"".equals(author)) {
                author = author + "; ";
            }
            author = author + authorElt.getChildTextTrim("name", defNS);
        }
        return author;
    }

    private static String getContentType(Element elt) {
        String type = elt.getAttributeValue("type");
        return type == null ? "text" : type;
    }

    public static String getDescription(Element item, Namespace namespace) {
        String strDesc = "";
        List contents = item.getChildren("content", namespace);
        Element elDesc = contents.size() > 0 ? (Element)contents.get(0) : item.getChild("summary", namespace);
        if (elDesc != null) {
            strDesc = AtomParserUtils.getValue(elDesc, Atom_1_0_Parser.getMode(elDesc));
        }
        return strDesc;
    }

    static String getMode(Element elt) {
        return Atom_1_0_Parser.getMode(Atom_1_0_Parser.getContentType(elt));
    }

    static String getMode(String type) {
        if (type == null) {
            return "escaped";
        }
        if ("text".equals(type) || "html".equals(type)) {
            return "escaped";
        }
        if ("xhtml".equals(type)) {
            return "xml";
        }
        if (type.substring(type.length() - "xml".length()).equals("xml")) {
            return "xml";
        }
        return "base64";
    }

    public ChannelIF parse(ChannelBuilderIF cBuilder, Element channel) throws ParseException {
        Element rights;
        Element updated;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        Namespace defNS = ParserUtils.getDefaultNS(channel);
        if (defNS == null) {
            defNS = Namespace.NO_NAMESPACE;
            LOGGER.info((Object)"No default namespace found.");
        } else if (defNS.getURI() == null || !defNS.getURI().equals("http://www.w3.org/2005/Atom")) {
            LOGGER.warn((Object)"Namespace is not really supported, still trying assuming Atom 1.0 format");
        }
        LOGGER.debug((Object)"start parsing.");
        ParserUtils.matchCaseOfChildren(channel, new String[]{"title", "subtitle", "updated", "published", "author", "generator", "rights", "link", "entry"});
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title", defNS));
        chnl.setFormat(ChannelFormat.ATOM_1_0);
        if (channel.getChild("subtitle") != null) {
            chnl.setDescription(channel.getChildTextTrim("subtitle", defNS));
        }
        if ((updated = channel.getChild("updated", defNS)) != null) {
            chnl.setPubDate(ParserUtils.getDate(updated.getTextTrim()));
        }
        List authors = channel.getChildren("author", defNS);
        chnl.setCreator(Atom_1_0_Parser.getAuthorString(authors, defNS));
        Element generator = channel.getChild("generator", defNS);
        if (generator != null) {
            chnl.setGenerator(generator.getTextTrim());
        }
        if ((rights = channel.getChild("rights", defNS)) != null) {
            chnl.setCopyright(AtomParserUtils.getValue(rights, Atom_1_0_Parser.getMode(rights)));
        }
        List links = channel.getChildren("link", defNS);
        Iterator i = links.iterator();
        URL linkUrl = null;
        while (i.hasNext()) {
            Element linkElement = (Element)i.next();
            String rel = linkElement.getAttributeValue("rel");
            String href = linkElement.getAttributeValue("href");
            if (rel == null && href != null && linkUrl == null) {
                linkUrl = ParserUtils.getURL(href);
                continue;
            }
            if (rel == null || href == null || !rel.equals("alternate")) continue;
            linkUrl = ParserUtils.getURL(href);
            break;
        }
        if (linkUrl != null) {
            chnl.setSite(linkUrl);
        }
        List items = channel.getChildren("entry", defNS);
        for (Element item : items) {
            Element elCategory;
            ParserUtils.matchCaseOfChildren(item, new String[]{"title", "link", "content", "summary", "published", "author"});
            Element elTitle = item.getChild("title", defNS);
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = AtomParserUtils.getValue(elTitle, Atom_1_0_Parser.getMode(elTitle));
                LOGGER.debug((Object)("Parsing title " + elTitle.getTextTrim() + "->" + strTitle));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Entry element found (" + strTitle + ")."));
            }
            String strLink = AtomParserUtils.getItemLink(item, defNS);
            String strDesc = Atom_1_0_Parser.getDescription(item, defNS);
            ItemIF curItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            curItem.setFound(dateParsed);
            List itemAuthors = item.getChildren("author", defNS);
            curItem.setCreator(Atom_1_0_Parser.getAuthorString(itemAuthors, defNS));
            Element elIssued = item.getChild("published", defNS);
            if (elIssued == null) {
                Element elUpdated = item.getChild("updated", defNS);
                if (elUpdated != null) {
                    curItem.setDate(ParserUtils.getDate(elUpdated.getTextTrim()));
                }
            } else {
                curItem.setDate(ParserUtils.getDate(elIssued.getTextTrim()));
            }
            if ((elCategory = item.getChild("category", defNS)) == null) continue;
            curItem.setSubject(elCategory.getTextTrim());
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    private static class Atom_1_0_ParserHolder {
        private static Atom_1_0_Parser instance = new Atom_1_0_Parser();

        private Atom_1_0_ParserHolder() {
        }
    }
}

