/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.hibernate;

import de.nava.informa.impl.hibernate.Category;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.impl.hibernate.ChannelSubscription;
import de.nava.informa.impl.hibernate.Cloud;
import de.nava.informa.impl.hibernate.Image;
import de.nava.informa.impl.hibernate.Item;
import de.nava.informa.impl.hibernate.ItemEnclosure;
import de.nava.informa.impl.hibernate.ItemGuid;
import de.nava.informa.impl.hibernate.ItemMetadata;
import de.nava.informa.impl.hibernate.ItemSource;
import de.nava.informa.impl.hibernate.TextInput;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class SessionHandler {
    private static Log logger = LogFactory.getLog(SessionHandler.class);
    private static SessionHandler myInstance;
    private Configuration cfg = new Configuration();
    private SessionFactory sessFactory;
    private Connection conn;
    private Session curSession;

    private SessionHandler(Properties props) throws HibernateException {
        try {
            this.cfg.configure();
        }
        catch (HibernateException he) {
            logger.info((Object)"Can't find \"hibernate.cfg.xml\" in classpath.");
        }
        this.cfg.addClass(Channel.class).addClass(Item.class).addClass(ItemGuid.class).addClass(ItemEnclosure.class).addClass(ItemSource.class).addClass(Cloud.class).addClass(Category.class).addClass(ChannelGroup.class).addClass(ChannelSubscription.class).addClass(Image.class).addClass(ItemMetadata.class).addClass(TextInput.class);
        if (props != null) {
            this.cfg.addProperties(props);
        }
        this.sessFactory = this.cfg.buildSessionFactory();
    }

    public static synchronized SessionHandler getInstance(Properties props) throws HibernateException {
        if (myInstance == null) {
            myInstance = new SessionHandler(props);
        }
        return myInstance;
    }

    public static SessionHandler getInstance() throws HibernateException {
        return SessionHandler.getInstance(null);
    }

    public Session getSession() throws HibernateException {
        this.curSession = this.conn != null ? this.sessFactory.openSession(this.conn) : this.sessFactory.openSession();
        return this.curSession;
    }

    public Session getSession(Connection conn) {
        this.conn = conn;
        this.curSession = this.sessFactory.openSession(conn);
        return this.curSession;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public boolean isSessionOpen() {
        return this.curSession.isOpen();
    }
}

