/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.impl.basic.IdGenerator;
import de.nava.informa.utils.XmlPathUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
implements ItemIF {
    private static final long serialVersionUID = -8346101720187629760L;
    private long id = IdGenerator.getInstance().getId();
    private String title;
    private String description;
    private URL link;
    private Collection<CategoryIF> categories;
    private String creator;
    private String subject;
    private Date date;
    private Date found;
    private ItemGuidIF guid;
    private URL comments;
    private ItemSourceIF source;
    private ItemEnclosureIF enclosure;
    private Element itemElement;
    private ChannelIF channel;
    private boolean unRead;

    public Item() {
        this(null, null, "[Unknown Item]", null, null);
    }

    public Item(String title, String description, URL link) {
        this(null, null, title, description, link);
    }

    public Item(ChannelIF channel, String title, String description, URL link) {
        this(null, channel, title, description, link);
    }

    public Item(Element itemElement, String title, String description, URL link) {
        this(itemElement, null, title, description, link);
    }

    public Item(Element itemElement, ChannelIF channel, String title, String description, URL link) {
        this.itemElement = itemElement;
        this.channel = channel;
        this.title = title;
        this.description = description;
        this.link = link;
        this.categories = new ArrayList<CategoryIF>();
        this.unRead = true;
        this.unRead = true;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public ChannelIF getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(ChannelIF channel) {
        this.channel = channel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean getUnRead() {
        return this.unRead;
    }

    @Override
    public void setUnRead(boolean val) {
        this.unRead = val;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public void setLink(URL link) {
        this.link = link;
    }

    @Override
    public Collection getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(Collection<CategoryIF> categories) {
        this.categories = categories;
    }

    @Override
    public void addCategory(CategoryIF category) {
        this.categories.add(category);
    }

    @Override
    public void removeCategory(CategoryIF category) {
        this.categories.remove(category);
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Date getFound() {
        return this.found;
    }

    @Override
    public void setFound(Date found) {
        this.found = found;
    }

    @Override
    public ItemGuidIF getGuid() {
        return this.guid;
    }

    @Override
    public void setGuid(ItemGuidIF guid) {
        this.guid = guid;
    }

    @Override
    public URL getComments() {
        return this.comments;
    }

    @Override
    public void setComments(URL comments) {
        this.comments = comments;
    }

    @Override
    public ItemSourceIF getSource() {
        return this.source;
    }

    @Override
    public void setSource(ItemSourceIF source) {
        this.source = source;
    }

    @Override
    public ItemEnclosureIF getEnclosure() {
        return this.enclosure;
    }

    @Override
    public void setEnclosure(ItemEnclosureIF enclosure) {
        this.enclosure = enclosure;
    }

    @Override
    public String getElementValue(String path) {
        return XmlPathUtils.getElementValue(this.itemElement, path);
    }

    @Override
    public String[] getElementValues(String path, String[] elements) {
        return XmlPathUtils.getElementValues(this.itemElement, path, elements);
    }

    @Override
    public String getAttributeValue(String path, String attribute) {
        return XmlPathUtils.getAttributeValue(this.itemElement, path, attribute);
    }

    @Override
    public String[] getAttributeValues(String path, String[] attributes) {
        return XmlPathUtils.getAttributeValues(this.itemElement, path, attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemIF)) {
            return false;
        }
        ItemIF item = (ItemIF)o;
        String itemTitle = item.getTitle();
        if (this.title != null ? !this.title.equals(itemTitle) : itemTitle != null) {
            return false;
        }
        URL itemLink = item.getLink();
        if (this.link != null ? itemLink == null || !this.link.toString().equalsIgnoreCase(itemLink.toString()) : itemLink != null) {
            return false;
        }
        String itemDescription = item.getDescription();
        return !(this.description != null ? !this.description.equals(itemDescription) : itemDescription != null);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.title).append(this.description).append(this.link);
        return sb.toString().hashCode();
    }

    public String toString() {
        return "[Item (" + this.id + "): " + this.title + "]";
    }
}

