/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.impl.basic.IdGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelGroup
implements ChannelGroupIF {
    private static final long serialVersionUID = -4037744833783193972L;
    private long id;
    private String title;
    private Collection<ChannelIF> channels;
    private ChannelGroupIF parent;
    private List<ChannelGroupIF> children;

    public ChannelGroup() {
        this("[Unknown title]");
    }

    public ChannelGroup(String title) {
        this(IdGenerator.getInstance().getId(), null, title);
    }

    public ChannelGroup(long id, String title) {
        this(id, null, title);
    }

    public ChannelGroup(long id, ChannelGroupIF parent, String title) {
        this.id = id;
        this.title = title;
        this.channels = new ArrayList<ChannelIF>();
        this.parent = parent;
        this.children = new ArrayList<ChannelGroupIF>();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void add(ChannelIF channel) {
        this.channels.add(channel);
    }

    @Override
    public void remove(ChannelIF channel) {
        this.channels.remove(channel);
    }

    @Override
    public Collection<ChannelIF> getAll() {
        return this.channels;
    }

    @Override
    public ChannelIF getById(long id) {
        for (ChannelIF channel : this.channels) {
            if (channel.getId() != id) continue;
            return channel;
        }
        return null;
    }

    @Override
    public ChannelGroupIF getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ChannelGroupIF parent) {
        this.parent = parent;
    }

    public Collection getChildren() {
        return this.children;
    }

    @Override
    public void addChild(ChannelGroupIF child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(ChannelGroupIF child) {
        this.children.remove(child);
    }

    public String toString() {
        return "[ChannelGroup (" + this.id + ")]";
    }
}

