/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.Category;
import de.nava.informa.impl.basic.Channel;
import de.nava.informa.impl.basic.ChannelGroup;
import de.nava.informa.impl.basic.Cloud;
import de.nava.informa.impl.basic.Image;
import de.nava.informa.impl.basic.Item;
import de.nava.informa.impl.basic.ItemEnclosure;
import de.nava.informa.impl.basic.ItemGuid;
import de.nava.informa.impl.basic.ItemSource;
import de.nava.informa.impl.basic.TextInput;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class ChannelBuilder
implements ChannelBuilderIF {
    private static Log logger = LogFactory.getLog(ChannelBuilder.class);

    public ChannelBuilder() {
        logger.debug((Object)"New channel builder for the in-memory backend");
    }

    public void init(Properties props) throws ChannelBuilderException {
        logger.debug((Object)"Initialising channel builder for in-memory backend");
    }

    public ChannelGroupIF createChannelGroup(String title) {
        return new ChannelGroup(title);
    }

    public ChannelIF createChannel(String title, String location) {
        return null;
    }

    public ChannelIF createChannel(Element channelElement, String title, String location) {
        return null;
    }

    public ChannelIF createChannel(String title) {
        return new Channel(title);
    }

    public ChannelIF createChannel(Element channelElement, String title) {
        return new Channel(channelElement, title);
    }

    public ItemIF createItem(ChannelIF channel, String title, String description, URL link) {
        return this.createItem(null, channel, title, description, link);
    }

    public ItemIF createItem(Element itemElement, ChannelIF channel, String title, String description, URL link) {
        Item item = new Item(itemElement, channel, title, description, link);
        if (channel != null) {
            channel.addItem(item);
        }
        return item;
    }

    public ItemIF createItem(ChannelIF chan, ItemIF oldItem) {
        return this.createItem(null, chan, oldItem.getTitle(), oldItem.getDescription(), oldItem.getLink());
    }

    public ImageIF createImage(String title, URL location, URL link) {
        return new Image(title, location, link);
    }

    public TextInputIF createTextInput(String title, String description, String name, URL link) {
        return new TextInput(title, description, name, link);
    }

    public CloudIF createCloud(String domain, int port, String path, String registerProcedure, String protocol) {
        logger.info((Object)"ChannelBuilder is creating a Basic Cloud");
        return new Cloud(domain, port, path, registerProcedure, protocol);
    }

    public ItemSourceIF createItemSource(ItemIF item, String name, String location, Date timestamp) {
        return new ItemSource(item, name, location, timestamp);
    }

    public ItemEnclosureIF createItemEnclosure(ItemIF item, URL location, String type, int length) {
        return new ItemEnclosure(item, location, type, length);
    }

    public ItemGuidIF createItemGuid(ItemIF item, String location, boolean permaLink) {
        return new ItemGuid(item, location, permaLink);
    }

    public CategoryIF createCategory(CategoryIF parent, String title) {
        Category cat = new Category(title);
        if (parent != null) {
            parent.addChild(cat);
        }
        return cat;
    }

    public void close() throws ChannelBuilderException {
        logger.debug((Object)"Closing channel builder for in-memory backend");
    }

    public void beginTransaction() throws ChannelBuilderException {
        logger.debug((Object)"No-op beginTransaction for in-memory backend");
    }

    public void endTransaction() throws ChannelBuilderException {
        logger.debug((Object)"No-op endTransaction for in-memory backend");
    }

    public void update(Object obj) {
        logger.debug((Object)"No-op update for in-memory backend");
    }
}

