/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelObserverIF;
import de.nava.informa.core.ChannelUpdatePeriod;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.IdGenerator;
import de.nava.informa.utils.XmlPathUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
implements ChannelIF {
    private static final long serialVersionUID = 8793309902338066823L;
    private long id = IdGenerator.getInstance().getId();
    private String title;
    private String description;
    private URL location;
    private URL site;
    private String creator;
    private String publisher;
    private String language;
    private ChannelFormat format;
    private Map<Long, ItemIF> items;
    private ImageIF image;
    private CloudIF cloud;
    private TextInputIF textInput;
    private String copyright;
    private Collection<CategoryIF> categories;
    private Date lastUpdated;
    private Date lastBuild;
    private Date pubDate;
    private String rating;
    private String generator;
    private String docs;
    private int ttl = -1;
    private Element channelElement;
    private ChannelUpdatePeriod updatePeriod = null;
    private int updateFrequency = -1;
    private Date updateBase;
    private transient Collection<ChannelObserverIF> observers;

    public Channel() {
        this((String)null);
    }

    public Channel(String title) {
        this(null, title);
    }

    public Channel(Element channelElement) {
        this(channelElement, "Unnamed channel");
    }

    public Channel(Element channelElement, String title) {
        this.channelElement = channelElement;
        this.title = title;
        this.items = Collections.synchronizedMap(new LinkedHashMap());
        this.categories = new ArrayList<CategoryIF>();
        this.observers = new ArrayList<ChannelObserverIF>();
        this.format = ChannelFormat.UNKNOWN_CHANNEL_FORMAT;
        this.lastUpdated = new Date();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URL location) {
        this.location = location;
    }

    @Override
    public URL getSite() {
        return this.site;
    }

    @Override
    public void setSite(URL site) {
        this.site = site;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getRating() {
        return this.rating;
    }

    @Override
    public void setRating(String rating) {
        this.rating = rating;
    }

    @Override
    public CloudIF getCloud() {
        return this.cloud;
    }

    @Override
    public void setCloud(CloudIF cloud) {
        this.cloud = cloud;
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String generator) {
        this.generator = generator;
    }

    @Override
    public String getDocs() {
        return this.docs;
    }

    @Override
    public void setDocs(String docs) {
        this.docs = docs;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public ChannelFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(ChannelFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ItemIF> getItems() {
        Map<Long, ItemIF> map = this.items;
        synchronized (map) {
            return Collections.synchronizedSet(new LinkedHashSet<ItemIF>(this.items.values()));
        }
    }

    @Override
    public void addItem(ItemIF item) {
        this.items.put(new Long(item.getId()), item);
        item.setChannel(this);
        this.notifyObserversItemAdded(item);
    }

    @Override
    public void removeItem(ItemIF item) {
        this.items.remove(new Long(item.getId()));
    }

    @Override
    public ItemIF getItem(long anId) {
        return this.items.get(new Long(anId));
    }

    @Override
    public ImageIF getImage() {
        return this.image;
    }

    @Override
    public void setImage(ImageIF image) {
        this.image = image;
    }

    @Override
    public TextInputIF getTextInput() {
        return this.textInput;
    }

    @Override
    public void setTextInput(TextInputIF textInput) {
        this.textInput = textInput;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Override
    public Collection getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(Collection<CategoryIF> categories) {
        this.categories = categories;
    }

    @Override
    public void addCategory(CategoryIF category) {
        this.categories.add(category);
    }

    @Override
    public void removeCategory(CategoryIF category) {
        this.categories.remove(category);
    }

    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        this.notifyObserversChannelUpdated();
    }

    @Override
    public Date getLastBuildDate() {
        return this.lastBuild;
    }

    @Override
    public void setLastBuildDate(Date date) {
        this.lastBuild = date;
    }

    @Override
    public Date getPubDate() {
        return this.pubDate;
    }

    @Override
    public void setPubDate(Date pubDate) {
        this.pubDate = pubDate;
    }

    public void setAllProperties(ChannelIF sourceChan) {
        this.setTitle(sourceChan.getTitle());
        this.setDescription(sourceChan.getDescription());
        this.setSite(sourceChan.getSite());
        this.setCreator(sourceChan.getCreator());
        this.setCopyright(sourceChan.getCopyright());
        this.setPublisher(sourceChan.getPublisher());
        this.setLanguage(sourceChan.getLanguage());
        this.setImage(sourceChan.getImage());
        this.setTextInput(sourceChan.getTextInput());
        this.setRating(sourceChan.getRating());
        this.setGenerator(sourceChan.getGenerator());
        this.setDocs(sourceChan.getDocs());
        this.setTtl(sourceChan.getTtl());
        this.setCloud(sourceChan.getCloud());
        this.setLastBuildDate(sourceChan.getLastBuildDate());
        this.setUpdateBase(sourceChan.getUpdateBase());
        this.setUpdateFrequency(sourceChan.getUpdateFrequency());
        this.setUpdatePeriod(sourceChan.getUpdatePeriod());
        this.setPubDate(sourceChan.getPubDate());
    }

    @Override
    public ChannelUpdatePeriod getUpdatePeriod() {
        return this.updatePeriod;
    }

    @Override
    public void setUpdatePeriod(ChannelUpdatePeriod updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    @Override
    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public void setUpdateFrequency(int updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    @Override
    public Date getUpdateBase() {
        return this.updateBase;
    }

    @Override
    public void setUpdateBase(Date updateBase) {
        this.updateBase = updateBase;
    }

    @Override
    public String getElementValue(String path) {
        return XmlPathUtils.getElementValue(this.channelElement, path);
    }

    @Override
    public String[] getElementValues(String path, String[] elements) {
        return XmlPathUtils.getElementValues(this.channelElement, path, elements);
    }

    @Override
    public String getAttributeValue(String path, String attribute) {
        return XmlPathUtils.getAttributeValue(this.channelElement, path, attribute);
    }

    @Override
    public String[] getAttributeValues(String path, String[] attributes) {
        return XmlPathUtils.getAttributeValues(this.channelElement, path, attributes);
    }

    @Override
    public void addObserver(ChannelObserverIF o) {
        this.observers.add(o);
    }

    @Override
    public void removeObserver(ChannelObserverIF o) {
        this.observers.remove(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelIF)) {
            return false;
        }
        ChannelIF channel = (ChannelIF)o;
        URL channelLocation = channel.getLocation();
        if (this.location != null ? channelLocation == null || !this.location.toString().equalsIgnoreCase(channelLocation.toString()) : channelLocation != null) {
            return false;
        }
        String channelTitle = channel.getTitle();
        if (this.title != null ? !this.title.equals(channelTitle) : channelTitle != null) {
            return false;
        }
        String channelDescription = channel.getDescription();
        return !(this.description != null ? !this.description.equals(channelDescription) : channelDescription != null);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.title).append(this.description).append(this.location);
        return sb.toString().hashCode();
    }

    public String toString() {
        return "[Basic Channel (" + this.id + "): " + this.title + " (" + this.location + " )]";
    }

    private void notifyObserversItemAdded(ItemIF newItem) {
        for (ChannelObserverIF o : this.observers) {
            o.itemAdded(newItem);
        }
    }

    private void notifyObserversChannelUpdated() {
        for (ChannelObserverIF o : this.observers) {
            o.channelRetrieved(this);
        }
    }
}

