/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.exporters;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RSS_2_0_Exporter
implements ChannelExporterIF {
    private static final String RSS_VERSION = "2.0";
    private static final String NS_DC = "http://purl.org/dc/elements/1.1/";
    private static final String NS_SY = "http://purl.org/rss/1.0/modules/syndication/";
    private static final String NS_ADMIN = "http://webns.net/mvcb/";
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private Writer writer;
    private String encoding;

    public RSS_2_0_Exporter(String filename) throws IOException {
        this(new File(filename), "utf-8");
    }

    public RSS_2_0_Exporter(File file) throws IOException {
        this(file, "utf-8");
    }

    public RSS_2_0_Exporter(File file, String encoding) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.encoding = encoding;
    }

    public RSS_2_0_Exporter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    private Element getCategoryElements(Element elem, CategoryIF category, StringBuffer catString) {
        StringBuffer l_catString = catString == null || catString.length() < 1 ? new StringBuffer(category.getTitle()) : catString.append("/").append(category.getTitle());
        Collection categories = category.getChildren();
        if (categories.size() == 0) {
            elem.addContent((Content)new Element("category").setText(l_catString.toString()));
        } else {
            for (CategoryIF childCat : categories) {
                elem = this.getCategoryElements(elem, childCat, l_catString);
            }
        }
        return elem;
    }

    public void write(ChannelIF channel) throws IOException {
        if (this.writer == null) {
            throw new RuntimeException("No writer has been initialized.");
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding(this.encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        Namespace dcNs = Namespace.getNamespace((String)"dc", (String)NS_DC);
        Namespace syNs = Namespace.getNamespace((String)"sy", (String)NS_SY);
        Namespace adminNs = Namespace.getNamespace((String)"admin", (String)NS_ADMIN);
        Element rootElem = new Element("rss");
        rootElem.addNamespaceDeclaration(dcNs);
        rootElem.addNamespaceDeclaration(syNs);
        rootElem.addNamespaceDeclaration(adminNs);
        rootElem.setAttribute("version", RSS_VERSION);
        Element channelElem = new Element("channel");
        channelElem.addContent((Content)new Element("title").setText(channel.getTitle()));
        if (channel.getSite() != null) {
            channelElem.addContent((Content)new Element("link").setText(channel.getSite().toString()));
        }
        channelElem.addContent((Content)new Element("description").setText(channel.getDescription()));
        if (channel.getLanguage() != null) {
            channelElem.addContent((Content)new Element("language", dcNs).setText(channel.getLanguage()));
        }
        if (channel.getCopyright() != null) {
            channelElem.addContent((Content)new Element("copyright", dcNs).setText(channel.getCopyright()));
        }
        if (channel.getPubDate() != null) {
            channelElem.addContent((Content)new Element("pubDate").setText(ParserUtils.formatDate(channel.getPubDate())));
        }
        if (channel.getCategories() != null) {
            Collection categories = channel.getCategories();
            for (CategoryIF cat : categories) {
                channelElem = this.getCategoryElements(channelElem, cat, null);
            }
        }
        if (channel.getUpdateBase() != null) {
            channelElem.addContent((Content)new Element("updateBase", syNs).setText(df.format(channel.getUpdateBase())));
        }
        if (channel.getUpdatePeriod() != null) {
            channelElem.addContent((Content)new Element("updateFrequency", syNs).setText(new Integer(channel.getUpdateFrequency()).toString()));
            channelElem.addContent((Content)new Element("updatePeriod", syNs).setText(channel.getUpdatePeriod().toString()));
        }
        if (channel.getImage() != null) {
            Element imgElem = new Element("image");
            imgElem.addContent((Content)new Element("title").setText(channel.getImage().getTitle()));
            imgElem.addContent((Content)new Element("url").setText(channel.getImage().getLocation().toString()));
            imgElem.addContent((Content)new Element("link").setText(channel.getImage().getLink().toString()));
            imgElem.addContent((Content)new Element("height").setText("" + channel.getImage().getHeight()));
            imgElem.addContent((Content)new Element("width").setText("" + channel.getImage().getWidth()));
            imgElem.addContent((Content)new Element("description").setText(channel.getImage().getDescription()));
            channelElem.addContent((Content)imgElem);
        }
        Set<ItemIF> items = channel.getItems();
        for (ItemIF item : items) {
            Element itemElem = new Element("item");
            itemElem.addContent((Content)new Element("title").setText(item.getTitle()));
            if (item.getLink() != null) {
                itemElem.addContent((Content)new Element("link").setText(item.getLink().toString()));
            }
            if (item.getDescription() != null) {
                itemElem.addContent((Content)new Element("description").setText(item.getDescription()));
            }
            if (item.getCategories() != null) {
                Collection categories = item.getCategories();
                for (CategoryIF cat : categories) {
                    itemElem = this.getCategoryElements(itemElem, cat, null);
                }
            }
            if (item.getDate() != null) {
                itemElem.addContent((Content)new Element("pubDate").setText(ParserUtils.formatDate(item.getDate())));
            }
            if (item.getGuid() != null) {
                Element guid = new Element("guid").setText(item.getGuid().getLocation());
                guid.setAttribute("isPermaLink", Boolean.toString(item.getGuid().isPermaLink()));
                itemElem.addContent((Content)guid);
            }
            if (item.getComments() != null) {
                itemElem.addContent((Content)new Element("comments").setText(item.getComments().toString()));
            }
            channelElem.addContent((Content)itemElem);
        }
        rootElem.addContent((Content)channelElem);
        Document doc = new Document(rootElem);
        outputter.output(doc, this.writer);
        this.writer.close();
    }
}

