/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.exporters;

import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RSS_0_91_Exporter
implements ChannelExporterIF {
    public static final String PUBLIC_ID = "-//Netscape Communications//DTD RSS 0.91//EN";
    public static final String SYSTEM_ID = "http://my.netscape.com/publish/formats/rss-0.91.dtd";
    public static final String RSS_VERSION = "0.91";
    private Writer writer;
    private String encoding;

    public RSS_0_91_Exporter(String filename) throws IOException {
        this(new File(filename), "utf-8");
    }

    public RSS_0_91_Exporter(File file) throws IOException {
        this(file, "utf-8");
    }

    public RSS_0_91_Exporter(File file, String encoding) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.encoding = encoding;
    }

    public RSS_0_91_Exporter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void write(ChannelIF channel) throws IOException {
        if (this.writer == null) {
            throw new RuntimeException("No writer has been initialized.");
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding(this.encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        Element rootElem = new Element("rss");
        rootElem.setAttribute("version", RSS_VERSION);
        Element channelElem = new Element("channel");
        channelElem.addContent((Content)new Element("title").setText(channel.getTitle()));
        channelElem.addContent((Content)new Element("description").setText(channel.getDescription()));
        if (channel.getSite() != null) {
            channelElem.addContent((Content)new Element("link").setText(channel.getSite().toString()));
        }
        if (channel.getLanguage() != null) {
            channelElem.addContent((Content)new Element("language").setText(channel.getLanguage()));
        }
        Set<ItemIF> items = channel.getItems();
        for (ItemIF item : items) {
            Element itemElem = new Element("item");
            itemElem.addContent((Content)new Element("title").setText(item.getTitle()));
            if (item.getLink() != null) {
                itemElem.addContent((Content)new Element("link").setText(item.getLink().toString()));
            }
            if (item.getDescription() != null) {
                itemElem.addContent((Content)new Element("description").setText(item.getDescription()));
            }
            if (item.getDate() != null) {
                itemElem.addContent((Content)new Element("pubDate").setText(ParserUtils.formatDate(item.getDate())));
            }
            channelElem.addContent((Content)itemElem);
        }
        if (channel.getImage() != null) {
            Element imgElem = new Element("image");
            imgElem.addContent((Content)new Element("title").setText(channel.getImage().getTitle()));
            imgElem.addContent((Content)new Element("url").setText(channel.getImage().getLocation().toString()));
            imgElem.addContent((Content)new Element("link").setText(channel.getImage().getLink().toString()));
            imgElem.addContent((Content)new Element("height").setText("" + channel.getImage().getHeight()));
            imgElem.addContent((Content)new Element("width").setText("" + channel.getImage().getWidth()));
            imgElem.addContent((Content)new Element("description").setText(channel.getImage().getDescription()));
            channelElem.addContent((Content)imgElem);
        }
        if (channel.getCopyright() != null) {
            channelElem.addContent((Content)new Element("copyright").setText(channel.getCopyright()));
        }
        rootElem.addContent((Content)channelElem);
        DocType docType = new DocType("rss", PUBLIC_ID, SYSTEM_ID);
        Document doc = new Document(rootElem, docType);
        outputter.output(doc, this.writer);
    }
}

