/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.CurrentItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.Put;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.ShareableSequence;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExpressionTool {
    public static final int UNDECIDED = -1;
    public static final int NO_EVALUATION_NEEDED = 0;
    public static final int EVALUATE_VARIABLE = 1;
    public static final int MAKE_CLOSURE = 3;
    public static final int MAKE_MEMO_CLOSURE = 4;
    public static final int RETURN_EMPTY_SEQUENCE = 5;
    public static final int EVALUATE_AND_MATERIALIZE_VARIABLE = 6;
    public static final int CALL_EVALUATE_ITEM = 7;
    public static final int ITERATE_AND_MATERIALIZE = 8;
    public static final int PROCESS = 9;
    public static final int LAZY_TAIL_EXPRESSION = 10;
    public static final int SHARED_APPEND_EXPRESSION = 11;
    public static final int MAKE_INDEXED_VARIABLE = 12;
    public static final int MAKE_SINGLETON_CLOSURE = 13;

    private ExpressionTool() {
    }

    public static Expression make(String expression, StaticContext env, int start, int terminator, int lineNumber, boolean compileWithTracing) throws XPathException {
        ExpressionParser parser = new ExpressionParser();
        parser.setCompileWithTracing(compileWithTracing);
        if (terminator == -1) {
            terminator = 0;
        }
        Expression exp = parser.parse(expression, start, terminator, lineNumber, env);
        exp = ExpressionVisitor.make(env).simplify(exp);
        return exp;
    }

    public static void copyLocationInfo(Expression from, Expression to) {
        if (from != null && to != null) {
            to.setLocationId(from.getLocationId());
            to.setContainer(from.getContainer());
        }
    }

    public static Expression unsorted(Optimizer opt, Expression exp, boolean retainAllNodes) throws XPathException {
        if (exp instanceof Literal) {
            return exp;
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 13;
        offer.retainAllNodes = retainAllNodes;
        return exp.promote(offer);
    }

    public static Expression unsortedIfHomogeneous(Optimizer opt, Expression exp) throws XPathException {
        if (exp instanceof Literal) {
            return exp;
        }
        if (exp.getItemType(opt.getConfiguration().getTypeHierarchy()) instanceof AnyItemType) {
            return exp;
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 13;
        offer.retainAllNodes = false;
        return exp.promote(offer);
    }

    public static int lazyEvaluationMode(Expression exp) {
        if (exp instanceof Literal) {
            return 0;
        }
        if (exp instanceof VariableReference) {
            return 1;
        }
        if ((exp.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluationMode(exp);
        }
        if (exp instanceof ErrorExpression) {
            return 7;
        }
        if (exp instanceof LazyExpression) {
            if (Cardinality.allowsMany(exp.getCardinality())) {
                return 4;
            }
            return 13;
        }
        if (!Cardinality.allowsMany(exp.getCardinality())) {
            return ExpressionTool.eagerEvaluationMode(exp);
        }
        if (exp instanceof TailExpression) {
            TailExpression tail = (TailExpression)exp;
            Expression base = tail.getBaseExpression();
            if (base instanceof VariableReference) {
                return 10;
            }
            return 3;
        }
        if (exp instanceof Block && ((Block)exp).getChildren().length == 2 && (((Block)exp).getChildren()[0] instanceof VariableReference || ((Block)exp).getChildren()[0] instanceof Literal)) {
            return 11;
        }
        return 3;
    }

    public static int eagerEvaluationMode(Expression exp) {
        if (exp instanceof Literal && !(((Literal)exp).getValue() instanceof Closure)) {
            return 0;
        }
        if (exp instanceof VariableReference) {
            return 6;
        }
        int m = exp.getImplementationMethod();
        if ((m & 1) != 0) {
            return 7;
        }
        if ((m & 2) != 0) {
            return 8;
        }
        return 9;
    }

    public static ValueRepresentation evaluate(Expression exp, int evaluationMode, XPathContext context, int ref) throws XPathException {
        switch (evaluationMode) {
            case 0: {
                return ((Literal)exp).getValue();
            }
            case 1: {
                return ((VariableReference)exp).evaluateVariable(context);
            }
            case 3: {
                return Closure.make(exp, context, ref);
            }
            case 4: {
                return Closure.make(exp, context, ref == 1 ? 10 : ref);
            }
            case 13: {
                return new SingletonClosure(exp, context);
            }
            case 5: {
                return EmptySequence.getInstance();
            }
            case 6: {
                ValueRepresentation v = ((VariableReference)exp).evaluateVariable(context);
                if (v instanceof Closure) {
                    return SequenceExtent.makeSequenceExtent(((Closure)v).iterate());
                }
                return v;
            }
            case 7: {
                Item item = exp.evaluateItem(context);
                if (item == null) {
                    return EmptySequence.getInstance();
                }
                return item;
            }
            case -1: 
            case 8: {
                if (ref == 10000) {
                    return context.getConfiguration().getOptimizer().makeSequenceExtent(exp, ref, context);
                }
                return SequenceExtent.makeSequenceExtent(exp.iterate(context));
            }
            case 9: {
                Controller controller = context.getController();
                XPathContextMinor c2 = context.newMinorContext();
                c2.setOrigin(exp);
                SequenceOutputter seq = controller.allocateSequenceOutputter(20);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setHostLanguage(exp.getHostLanguage());
                seq.setPipelineConfiguration(pipe);
                c2.setTemporaryReceiver(seq);
                seq.open();
                exp.process(c2);
                seq.close();
                ValueRepresentation val = seq.getSequence();
                seq.reset();
                return val;
            }
            case 10: {
                TailExpression tail = (TailExpression)exp;
                VariableReference vr = (VariableReference)tail.getBaseExpression();
                ValueRepresentation base = ExpressionTool.evaluate(vr, 1, context, ref);
                if (base instanceof MemoClosure) {
                    SequenceIterator it = ((MemoClosure)base).iterate();
                    base = ((GroundedIterator)it).materialize();
                }
                if (base instanceof IntegerRange) {
                    long end;
                    long start = ((IntegerRange)base).getStart() + 1L;
                    if (start == (end = ((IntegerRange)base).getEnd())) {
                        return Int64Value.makeIntegerValue(end);
                    }
                    return new IntegerRange(start, end);
                }
                if (base instanceof SequenceExtent) {
                    return new SequenceExtent((SequenceExtent)base, tail.getStart() - 1, ((SequenceExtent)base).getLength() - tail.getStart() + 1);
                }
                return Closure.make(tail, context, ref);
            }
            case 11: {
                if (exp instanceof Block) {
                    Item i;
                    Value baseVal;
                    Block block = (Block)exp;
                    Expression base = block.getChildren()[0];
                    if (base instanceof Literal) {
                        baseVal = ((Literal)base).getValue();
                    } else if (base instanceof VariableReference) {
                        baseVal = Value.asValue(ExpressionTool.evaluate(base, 1, context, ref));
                        if (baseVal instanceof MemoClosure && ((MemoClosure)baseVal).isFullyRead()) {
                            baseVal = ((MemoClosure)baseVal).materialize();
                        }
                    } else {
                        throw new AssertionError((Object)("base of shared append expression is of class " + base.getClass()));
                    }
                    if (baseVal instanceof ShareableSequence && ((ShareableSequence)baseVal).isShareable()) {
                        Item i2;
                        List list = ((ShareableSequence)baseVal).getList();
                        SequenceIterator iter = block.getChildren()[1].iterate(context);
                        while ((i2 = iter.next()) != null) {
                            list.add(i2);
                        }
                        return new ShareableSequence(list);
                    }
                    ArrayList<Item> list = new ArrayList<Item>(20);
                    SequenceIterator iter = baseVal.iterate();
                    while ((i = iter.next()) != null) {
                        list.add(i);
                    }
                    iter = block.getChildren()[1].iterate(context);
                    while ((i = iter.next()) != null) {
                        list.add(i);
                    }
                    return new ShareableSequence(list);
                }
                return SequenceExtent.makeSequenceExtent(exp.iterate(context));
            }
            case 12: {
                return context.getConfiguration().getOptimizer().makeIndexedValue(exp.iterate(context));
            }
        }
        throw new IllegalArgumentException("Unknown evaluation mode " + evaluationMode);
    }

    public static ValueRepresentation lazyEvaluate(Expression exp, XPathContext context, int ref) throws XPathException {
        int evaluationMode = ExpressionTool.lazyEvaluationMode(exp);
        return ExpressionTool.evaluate(exp, evaluationMode, context, ref);
    }

    public static ValueRepresentation eagerEvaluate(Expression exp, XPathContext context) throws XPathException {
        int evaluationMode = ExpressionTool.eagerEvaluationMode(exp);
        return ExpressionTool.evaluate(exp, evaluationMode, context, 10);
    }

    public static int markTailFunctionCalls(Expression exp, StructuredQName qName, int arity) {
        return exp.markTailFunctionCalls(qName, arity);
    }

    public static String indent(int level) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "  ";
        }
        return s;
    }

    public static int allocateSlots(Expression exp, int nextFree, SlotManager frame) {
        return ExpressionTool.allocateSlots(exp, nextFree, frame, true);
    }

    private static int allocateSlots(Expression exp, int nextFree, SlotManager frame, boolean topLevel) {
        if (exp instanceof Assignation) {
            ((Assignation)exp).setSlotNumber(nextFree);
            int count = ((Assignation)exp).getRequiredSlots();
            nextFree += count;
            if (frame != null) {
                frame.allocateSlotNumber(((Assignation)exp).getVariableQName());
                if (count == 2) {
                    frame.allocateSlotNumber(((ForExpression)exp).getPositionVariableName());
                }
            }
        }
        if (exp instanceof VariableReference) {
            VariableReference var = (VariableReference)exp;
            Binding binding = var.getBinding();
            if (exp instanceof LocalVariableReference) {
                ((LocalVariableReference)var).setSlotNumber(binding.getLocalSlotNumber());
            }
            if (binding instanceof Assignation && binding.getLocalSlotNumber() < 0) {
                Assignation decl = (Assignation)binding;
                String msg = "*** Internal Saxon error: local variable encountered whose binding has been deleted";
                System.err.println(msg);
                System.err.println("Variable name: " + decl.getVariableName());
                System.err.println("Line number of reference: " + var.getLocationId());
                System.err.println("Line number of declaration: " + decl.getLocationId());
                System.err.println("DECLARATION:");
                decl.explain(System.err);
                throw new IllegalStateException(msg);
            }
        }
        Iterator children = exp.iterateSubExpressions();
        while (children.hasNext()) {
            Expression child = (Expression)children.next();
            nextFree = ExpressionTool.allocateSlots(child, nextFree, frame, false);
        }
        return nextFree;
    }

    public static boolean effectiveBooleanValue(SequenceIterator iterator) throws XPathException {
        Item first = iterator.next();
        if (first == null) {
            return false;
        }
        if (first instanceof NodeInfo) {
            iterator.close();
            return true;
        }
        if (first instanceof BooleanValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)first).getBooleanValue();
        }
        if (first instanceof StringValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return first.getStringValueCS().length() != 0;
        }
        if (first instanceof NumericValue) {
            NumericValue n;
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return (n = (NumericValue)first).compareTo(0L) != 0 && !n.isNaN();
        }
        if (first instanceof ObjectValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with an external object value");
            }
            return ((ObjectValue)first).getObject() != null;
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, string, or URI");
        return false;
    }

    public static void ebvError(String reason) throws XPathException {
        XPathException err = new XPathException("Effective boolean value is not defined for a " + reason);
        err.setErrorCode("FORG0006");
        err.setIsTypeError(true);
        throw err;
    }

    public static boolean dependsOnVariable(Expression e, Binding[] bindingList) {
        if (bindingList == null || bindingList.length == 0) {
            return false;
        }
        if (e instanceof VariableReference) {
            for (int i = 0; i < bindingList.length; ++i) {
                if (((VariableReference)e).getBinding() != bindingList[i]) continue;
                return true;
            }
            return false;
        }
        Iterator children = e.iterateSubExpressions();
        while (children.hasNext()) {
            Expression child = (Expression)children.next();
            if (!ExpressionTool.dependsOnVariable(child, bindingList)) continue;
            return true;
        }
        return false;
    }

    public static void gatherReferencedVariables(Expression e, List list) {
        if (e instanceof VariableReference) {
            Binding binding = ((VariableReference)e).getBinding();
            if (!list.contains(binding)) {
                list.add(binding);
            }
        } else {
            Iterator children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = (Expression)children.next();
                ExpressionTool.gatherReferencedVariables(child, list);
            }
        }
    }

    public static boolean callsFunction(Expression exp, StructuredQName qName) {
        if (exp instanceof FunctionCall && ((FunctionCall)exp).getFunctionName().equals(qName)) {
            return true;
        }
        Iterator iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression e = (Expression)iter.next();
            if (!ExpressionTool.callsFunction(e, qName)) continue;
            return true;
        }
        return false;
    }

    public static void gatherCalledFunctions(Expression e, List list) {
        if (e instanceof UserFunctionCall) {
            UserFunction function = ((UserFunctionCall)e).getFunction();
            if (!list.contains(function)) {
                list.add(function);
            }
        } else {
            Iterator children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = (Expression)children.next();
                ExpressionTool.gatherCalledFunctions(child, list);
            }
        }
    }

    public static void gatherCalledFunctionNames(Expression e, List list) {
        if (e instanceof UserFunctionCall) {
            StructuredQName name = ((UserFunctionCall)e).getFunctionName();
            int arity = ((UserFunctionCall)e).getNumberOfArguments();
            String key = name.getClarkName() + "/" + arity;
            if (!list.contains(key)) {
                list.add(key);
            }
        } else {
            Iterator children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = (Expression)children.next();
                ExpressionTool.gatherCalledFunctionNames(child, list);
            }
        }
    }

    public static void resetPropertiesWithinSubtree(Expression exp) {
        exp.resetLocalStaticProperties();
        Iterator children = exp.iterateSubExpressions();
        while (children.hasNext()) {
            Expression child = (Expression)children.next();
            ExpressionTool.resetPropertiesWithinSubtree(child);
        }
    }

    public static Expression resolveCallsToCurrentFunction(Expression exp, Configuration config) throws XPathException {
        if (ExpressionTool.callsFunction(exp, Current.FN_CURRENT)) {
            LetExpression let = new LetExpression();
            let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "current" + exp.hashCode()));
            let.setRequiredType(SequenceType.SINGLE_ITEM);
            let.setSequence(new CurrentItemExpression());
            PromotionOffer offer = new PromotionOffer(config.getOptimizer());
            offer.action = 14;
            offer.containingExpression = let;
            exp = exp.promote(offer);
            let.setAction(exp);
            return let;
        }
        return exp;
    }

    public static boolean isSubtreeExpression(Expression exp) {
        if (exp instanceof Literal) {
            return true;
        }
        if ((exp.getDependencies() & 0x1E) != 0) {
            if (exp instanceof ContextItemExpression) {
                return true;
            }
            if (exp instanceof AxisExpression) {
                return Axis.isSubtreeAxis[((AxisExpression)exp).getAxis()];
            }
            if ((exp.getIntrinsicDependencies() & 0x1E) != 0) {
                return false;
            }
            if (exp instanceof ExtensionFunctionCall) {
                return false;
            }
            Iterator sub = exp.iterateSubExpressions();
            while (sub.hasNext()) {
                Expression s = (Expression)sub.next();
                if (ExpressionTool.isSubtreeExpression(s)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void gatherVariableReferences(Expression exp, Binding binding, List list) {
        if (exp instanceof VariableReference && ((VariableReference)exp).getBinding() == binding) {
            list.add(exp);
        } else {
            Iterator iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                ExpressionTool.gatherVariableReferences((Expression)iter.next(), binding, list);
            }
        }
    }

    public static int getReferenceCount(Expression exp, Binding binding, boolean inLoop) {
        int rcount = 0;
        if (exp instanceof VariableReference && ((VariableReference)exp).getBinding() == binding) {
            if (((VariableReference)exp).isFiltered()) {
                return 10000;
            }
            rcount += inLoop ? 10 : 1;
        } else {
            boolean childLoop;
            Expression child;
            Iterator iter = exp.iterateSubExpressions();
            while (iter.hasNext() && (rcount += ExpressionTool.getReferenceCount(child = (Expression)iter.next(), binding, childLoop = inLoop || exp.hasLoopingSubexpression(child))) < 10000) {
            }
        }
        return rcount;
    }

    public static void gatherAllSubExpressions(Expression exp, HashSet set) {
        set.add(exp);
        Iterator iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            ExpressionTool.gatherAllSubExpressions((Expression)iter.next(), set);
        }
    }

    public static int expressionSize(Expression exp) {
        int total = 1;
        Iterator iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            total += ExpressionTool.expressionSize((Expression)iter.next());
        }
        return total;
    }

    public static void rebindVariableReferences(Expression exp, Binding oldBinding, Binding newBinding) {
        if (exp instanceof VariableReference) {
            if (((VariableReference)exp).getBinding() == oldBinding) {
                ((VariableReference)exp).fixup(newBinding);
            }
        } else {
            Iterator iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression e = (Expression)iter.next();
                ExpressionTool.rebindVariableReferences(e, oldBinding, newBinding);
            }
        }
    }

    public static boolean isAllowedInUpdatingContext(Expression exp) {
        return Literal.isEmptySequence(exp) || exp instanceof Error || exp.isUpdatingExpression() || exp instanceof Put || exp instanceof LetExpression && ExpressionTool.isAllowedInUpdatingContext(((LetExpression)exp).getAction());
    }
}

