/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ValueExp;

class QualifiedAttributeValueExp
extends AttributeValueExp {
    private static final long serialVersionUID = 8832517277410933254L;
    private String className;

    public QualifiedAttributeValueExp() {
    }

    public String getAttrClassName() {
        return this.className;
    }

    public String toString() {
        if (this.className != null) {
            return this.className + "." + super.toString();
        }
        return super.toString();
    }

    public QualifiedAttributeValueExp(String string, String string2) {
        super(string2);
        this.className = string;
    }

    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            String string = mBeanServer.getObjectInstance(objectName).getClassName();
            if (string.equals(this.className)) {
                return super.apply(objectName);
            }
            throw new InvalidApplicationException((Object)("Class name is " + string + ", should be " + this.className));
        }
        catch (Exception exception) {
            throw new InvalidApplicationException((Object)("Qualified attribute: " + exception));
        }
    }
}

