/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropShadowBorder
implements Border {
    private static final Map<Integer, Map<Position, BufferedImage>> CACHE = new HashMap<Integer, Map<Position, BufferedImage>>();
    private final Color lineColor;
    private final int lineWidth;
    private final int shadowSize;
    private final float shadowOpacity;
    private final int cornerSize;
    private final boolean showTopShadow;
    private final boolean showLeftShadow;
    private final boolean showBottomShadow;
    private final boolean showRightShadow;

    public DropShadowBorder() {
        this(UIManager.getColor("Control"), 1, 5);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, int shadowSize) {
        this(lineColor, lineWidth, shadowSize, 0.5f, 12, false, false, true, true);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, boolean showLeftShadow) {
        this(lineColor, lineWidth, 5, 0.5f, 12, false, showLeftShadow, true, true);
    }

    public DropShadowBorder(Color lineColor, int lineWidth, int shadowSize, float shadowOpacity, int cornerSize, boolean showTopShadow, boolean showLeftShadow, boolean showBottomShadow, boolean showRightShadow) {
        this.lineColor = lineColor;
        this.lineWidth = lineWidth;
        this.shadowSize = shadowSize;
        this.shadowOpacity = shadowOpacity;
        this.cornerSize = cornerSize;
        this.showTopShadow = showTopShadow;
        this.showLeftShadow = showLeftShadow;
        this.showBottomShadow = showBottomShadow;
        this.showRightShadow = showRightShadow;
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        Map<Position, BufferedImage> images = this.getImages(null);
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setColor(this.lineColor);
        Point topLeftShadowPoint = null;
        if (this.showLeftShadow || this.showTopShadow) {
            topLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y + this.shadowSize);
            } else if (this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x, y);
            } else if (!this.showLeftShadow && this.showTopShadow) {
                topLeftShadowPoint.setLocation(x + this.shadowSize, y);
            }
        }
        Point bottomLeftShadowPoint = null;
        if (this.showLeftShadow || this.showBottomShadow) {
            bottomLeftShadowPoint = new Point();
            if (this.showLeftShadow && !this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize);
            } else if (!this.showLeftShadow && this.showBottomShadow) {
                bottomLeftShadowPoint.setLocation(x + this.shadowSize, y + height - this.shadowSize);
            }
        }
        Point bottomRightShadowPoint = null;
        if (this.showRightShadow || this.showBottomShadow) {
            bottomRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize - this.shadowSize);
            } else if (this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize);
            } else if (!this.showRightShadow && this.showBottomShadow) {
                bottomRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y + height - this.shadowSize);
            }
        }
        Point topRightShadowPoint = null;
        if (this.showRightShadow || this.showTopShadow) {
            topRightShadowPoint = new Point();
            if (this.showRightShadow && !this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y + this.shadowSize);
            } else if (this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize, y);
            } else if (!this.showRightShadow && this.showTopShadow) {
                topRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y);
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (this.showLeftShadow) {
            Rectangle leftShadowRect = new Rectangle(x, topLeftShadowPoint.y + this.shadowSize, this.shadowSize, bottomLeftShadowPoint.y - topLeftShadowPoint.y - this.shadowSize);
            g2.drawImage(images.get((Object)Position.LEFT), leftShadowRect.x, leftShadowRect.y, leftShadowRect.width, leftShadowRect.height, null);
        }
        if (this.showBottomShadow) {
            Rectangle bottomShadowRect = new Rectangle(bottomLeftShadowPoint.x + this.shadowSize, y + height - this.shadowSize, bottomRightShadowPoint.x - bottomLeftShadowPoint.x - this.shadowSize, this.shadowSize);
            g2.drawImage(images.get((Object)Position.BOTTOM), bottomShadowRect.x, bottomShadowRect.y, bottomShadowRect.width, bottomShadowRect.height, null);
        }
        if (this.showRightShadow) {
            Rectangle rightShadowRect = new Rectangle(x + width - this.shadowSize, topRightShadowPoint.y + this.shadowSize, this.shadowSize, bottomRightShadowPoint.y - topRightShadowPoint.y - this.shadowSize);
            g2.drawImage(images.get((Object)Position.RIGHT), rightShadowRect.x, rightShadowRect.y, rightShadowRect.width, rightShadowRect.height, null);
        }
        if (this.showTopShadow) {
            Rectangle topShadowRect = new Rectangle(topLeftShadowPoint.x + this.shadowSize, y, topRightShadowPoint.x - topLeftShadowPoint.x - this.shadowSize, this.shadowSize);
            g2.drawImage(images.get((Object)Position.TOP), topShadowRect.x, topShadowRect.y, topShadowRect.width, topShadowRect.height, null);
        }
        if (this.showLeftShadow || this.showTopShadow) {
            g2.drawImage((Image)images.get((Object)Position.TOP_LEFT), topLeftShadowPoint.x, topLeftShadowPoint.y, null);
        }
        if (this.showLeftShadow || this.showBottomShadow) {
            g2.drawImage((Image)images.get((Object)Position.BOTTOM_LEFT), bottomLeftShadowPoint.x, bottomLeftShadowPoint.y, null);
        }
        if (this.showRightShadow || this.showBottomShadow) {
            g2.drawImage((Image)images.get((Object)Position.BOTTOM_RIGHT), bottomRightShadowPoint.x, bottomRightShadowPoint.y, null);
        }
        if (this.showRightShadow || this.showTopShadow) {
            g2.drawImage((Image)images.get((Object)Position.TOP_RIGHT), topRightShadowPoint.x, topRightShadowPoint.y, null);
        }
        g2.dispose();
    }

    private Map<Position, BufferedImage> getImages(Graphics2D g2) {
        Map<Position, BufferedImage> images = CACHE.get(this.shadowSize);
        if (images == null) {
            images = new HashMap<Position, BufferedImage>();
            int rectWidth = this.cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, this.cornerSize, this.cornerSize);
            int imageWidth = rectWidth + this.shadowSize * 2;
            BufferedImage image = new BufferedImage(imageWidth, imageWidth, 2);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            buffer.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowOpacity));
            buffer.translate(this.shadowSize, this.shadowSize);
            buffer.fill(rect);
            buffer.dispose();
            float blurry = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] blurKernel = new float[this.shadowSize * this.shadowSize];
            for (int i = 0; i < blurKernel.length; ++i) {
                blurKernel[i] = blurry;
            }
            ConvolveOp blur = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, blurKernel));
            BufferedImage targetImage = new BufferedImage(imageWidth, imageWidth, 2);
            ((Graphics2D)targetImage.getGraphics()).drawImage(image, blur, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int x = 1;
            int y = 1;
            int w = this.shadowSize;
            int h = this.shadowSize;
            images.put(Position.TOP_LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = 1;
            y = h;
            w = this.shadowSize;
            h = 1;
            images.put(Position.LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = 1;
            y = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = this.cornerSize + 1;
            y = rectWidth;
            w = 1;
            h = this.shadowSize;
            images.put(Position.BOTTOM, this.getSubImage(targetImage, x, y, w, h));
            y = x = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = rectWidth;
            y = this.cornerSize + 1;
            w = this.shadowSize;
            h = 1;
            images.put(Position.RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = rectWidth;
            y = 1;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.TOP_RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = this.shadowSize;
            y = 1;
            w = 1;
            h = this.shadowSize;
            images.put(Position.TOP, this.getSubImage(targetImage, x, y, w, h));
            image.flush();
        }
        return images;
    }

    private BufferedImage getSubImage(BufferedImage img, int x, int y, int w, int h) {
        BufferedImage ret = new BufferedImage(w, h, 2);
        Graphics2D g2 = ret.createGraphics();
        g2.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
        g2.dispose();
        return ret;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int top = this.showTopShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int left = this.showLeftShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int bottom = this.showBottomShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int right = this.showRightShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

