/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;
import org.jdesktop.swingx.util.SwingWorker;

public abstract class LoginService
extends AbstractBean {
    private Logger LOG = Logger.getLogger(LoginService.class.getName());
    private Vector<LoginListener> listenerList = new Vector();
    private SwingWorker loginWorker;
    private boolean synchronous;
    private String server;

    public LoginService() {
    }

    public LoginService(String server) {
        this.setServer(server);
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public String[] getUserRoles() {
        return null;
    }

    public void cancelAuthentication() {
        if (this.loginWorker != null) {
            this.loginWorker.cancel(true);
        }
    }

    public void startAuthentication(final String user, final char[] password, final String server) throws Exception {
        block5: {
            if (this.getSynchronous()) {
                try {
                    if (this.authenticate(user, password, server)) {
                        this.fireLoginSucceeded(new LoginEvent(this));
                        break block5;
                    }
                    this.fireLoginFailed(new LoginEvent(this));
                }
                catch (Throwable e) {
                    this.fireLoginFailed(new LoginEvent(this, e));
                }
            } else {
                this.loginWorker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        try {
                            final boolean result = LoginService.this.authenticate(user, password, server);
                            if (this.isCancelled()) {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                                return false;
                            }
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    if (result) {
                                        LoginService.this.fireLoginSucceeded(new LoginEvent(LoginService.this));
                                    } else {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this));
                                    }
                                }
                            });
                            return result;
                        }
                        catch (Throwable failed) {
                            if (!this.isCancelled()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this, failed));
                                    }
                                });
                            } else {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                            }
                            return false;
                        }
                    }
                };
                this.loginWorker.execute();
                this.fireLoginStarted(new LoginEvent(this));
            }
        }
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        boolean old = this.getSynchronous();
        this.synchronous = synchronous;
        this.firePropertyChange("synchronous", old, this.getSynchronous());
    }

    public void addLoginListener(LoginListener listener) {
        this.listenerList.add(listener);
    }

    public void removeLoginListener(LoginListener listener) {
        this.listenerList.remove(listener);
    }

    void fireLoginStarted(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginStarted(source);
        }
    }

    void fireLoginSucceeded(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginSucceeded(source);
        }
    }

    void fireLoginFailed(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginFailed(source);
        }
    }

    void fireLoginCanceled(LoginEvent source) {
        for (LoginListener listener : this.listenerList) {
            listener.loginCanceled(source);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        String old = this.getServer();
        this.server = server;
        this.firePropertyChange("server", old, this.getServer());
    }
}

