/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.wsi.test.validator.Artifacts;
import org.wsi.test.validator.CommandLineParser;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.Report;
import org.wsi.test.validator.ServiceExtension;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.service.ProfileService;

public class Validator {
    private Configuration config;
    private ProfileService profile;

    public Validator(String configURL) throws ValidatorException {
        List ps = new ServiceExtension("org.wsi.test.validator.profileservices.txt").getServiceInstances();
        if (ps.size() > 1) {
            throw new ValidatorException("Error:  multiple profile servces found");
        }
        this.profile = (ProfileService)ps.get(0);
        this.config = this.profile.getConfiguration(configURL);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Report runValidation() {
        Report report;
        try {
            Artifacts artifacts = new Artifacts(this.config);
            report = artifacts.validateAll(this.config, this.profile);
        }
        catch (Throwable t) {
            report = new Report(this.config, this.profile.getConformanceReportTitle(), this.profile.getReportNamespace(), this.profile.getVersionString(), this.profile.getReleaseDateString());
            report.reportAnalyzerFailure(t);
        }
        return report;
    }

    public ProfileService getAssertionService() {
        return this.profile;
    }

    public static void writeXmlFile(Document doc, String fileName) throws ValidatorException {
        DOMSource s = new DOMSource(doc);
        File f = new File(fileName);
        StreamResult result = new StreamResult(f);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(s, result);
        }
        catch (Exception e) {
            throw new ValidatorException(e);
        }
    }

    public void writeDescription(PrintStream out) {
        out.println("Conformance Analyzer Tool, Version:  " + this.profile.getVersionString() + ", Release Date:  " + this.profile.getReleaseDateString());
        out.println("Copyright (C) 2002-" + this.profile.getReleaseYearString() + " by The Web Services-Interoperability Organization and");
        out.println("Certain of its Members.  All Rights Reserved.");
        out.println("Use of this Material is governed by WS-I licenses included within the");
        out.println("documentation.\n");
        out.println("  verbose .................... " + this.config.getVerbose());
        out.println("  Assertion Results:");
        out.println("    type ..................... " + this.config.getAssertionResultsType().getName());
        out.println("    messageEntry ............. " + this.config.getAssertionResultsMessageEntry());
        out.println("    assertionDescription ..... " + this.config.getAssertionDescription());
        out.println("    failureMessage ........... " + this.config.getAssertionResultsFailureMessage());
        out.println("    failureDetail ............ " + this.config.getAssertionResultsFailureDetails());
        out.println("  Report File:");
        out.println("    replace .................. " + this.config.getReportFileReplace());
        out.println("    location ................. " + this.config.getReportFileLocation());
        out.println("    Style Sheet:");
        out.println("      href ................... " + this.config.getStyleSheetHref());
        out.println("      type ................... " + this.config.getStyleSheetType());
        out.println("  testAssertionsFile ......... " + this.config.getTadLocation());
        out.println("  Message Log File:");
        out.println("    location ................. " + this.config.getLogFileLocation());
        out.println("    correlationType .......... " + this.config.getLogFileCorrelationType());
        out.println("  description ................ " + this.config.getDescription());
        out.println("\nPlease wait while the specified artifacts are analyzed...");
    }

    public static void main(String[] args) {
        try {
            CommandLineParser p = new CommandLineParser(null, Arrays.asList("config"));
            p.parseArgs(args);
            String configFile = p.getOption("config");
            if (configFile == null) {
                configFile = "config.xml";
            }
            Validator v = new Validator(configFile);
            v.writeDescription(System.out);
            if (!v.getConfiguration().getReportFileReplace() && new File(v.getConfiguration().getReportFileLocation()).exists()) {
                System.out.println("Analyzer Error:  Report file already exists and replace option was not specified");
                System.exit(1);
            }
            Report r = v.runValidation();
            try {
                Validator.writeXmlFile(r.getReport(), v.getConfiguration().getReportFileLocation());
            }
            catch (ValidatorException e) {
                e.setUserReason("Could not open report file (" + v.getConfiguration().getReportFileLocation() + ") for writing");
                throw e;
            }
            if (r.analyzerFailed()) {
                System.out.println("Analyer failed.  See report for details.");
            } else {
                System.out.println("Conformance report has been created.");
            }
        }
        catch (ValidatorException e) {
            if (e.getUserReason() != null) {
                System.err.println("Error running validation:");
                System.err.println(e.getUserReason());
            } else {
                System.err.println("Unexpected error running validation:");
                System.err.println(e.getMessage());
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }
}

